/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http;

import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.Header;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.HttpClient;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.HttpMethod;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.URIException;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.methods.GetMethod;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.methods.HeadMethod;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.util.DateParser;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.util.URIUtil;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContentInfoFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.RandomAccessContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.URLFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileContentInfoFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpRandomAccesContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.MonitorInputStream;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.RandomAccessMode;
import java.io.IOException;
import java.io.InputStream;

public class HttpFileObject
extends AbstractFileObject {
    private final HttpFileSystem fileSystem;
    private final String urlCharset;
    private HeadMethod method;

    protected HttpFileObject(FileName name, HttpFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
        this.urlCharset = HttpFileSystemConfigBuilder.getInstance().getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    protected void doDetach() throws Exception {
        this.method = null;
    }

    protected FileType doGetType() throws Exception {
        this.method = new HeadMethod();
        this.setupMethod(this.method);
        HttpClient client = this.fileSystem.getClient();
        int status = client.executeMethod(this.method);
        this.method.releaseConnection();
        if (status == 200) {
            return FileType.FILE;
        }
        if (status == 404 || status == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        throw new Exception("Not implemented.");
    }

    protected long doGetContentSize() throws Exception {
        Header header = this.method.getResponseHeader("content-length");
        if (header == null) {
            return 0L;
        }
        return Integer.parseInt(header.getValue());
    }

    protected long doGetLastModifiedTime() throws Exception {
        Header header = this.method.getResponseHeader("last-modified");
        if (header == null) {
            throw new FileSystemException("vfs.provider.http/last-modified.error", this.getName());
        }
        return DateParser.parseDate(header.getValue()).getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        GetMethod getMethod = new GetMethod();
        this.setupMethod(getMethod);
        int status = this.fileSystem.getClient().executeMethod(getMethod);
        if (status != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName());
        }
        return new HttpInputStream(getMethod);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new HttpRandomAccesContent(this, mode);
    }

    void setupMethod(HttpMethod method) throws FileSystemException, URIException {
        String pathEncoded = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        method.setPath(pathEncoded);
        method.setFollowRedirects(true);
        method.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
    }

    protected String encodePath(String decodedPath) throws URIException {
        String pathEncoded = URIUtil.encodePath(decodedPath);
        return pathEncoded;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new HttpFileContentInfoFactory();
    }

    HeadMethod getHeadMethod() {
        return this.method;
    }

    static class HttpInputStream
    extends MonitorInputStream {
        private final GetMethod method;

        public HttpInputStream(GetMethod method) throws IOException {
            super(method.getResponseBodyAsStream());
            this.method = method;
        }

        protected void onClose() throws IOException {
            this.method.releaseConnection();
        }
    }
}

