/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.jar;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.jar.JarFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.jar.JarFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.zip.ZipFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.zip.ZipFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFileSystem
extends ZipFileSystem {
    private Attributes attributes;

    protected JarFileSystem(FileName rootName, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, file, fileSystemOptions);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new JarFile(file);
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.jar/open-jar-file.error", file, (Throwable)ioe);
        }
    }

    protected ZipFileObject createZipFileObject(FileName name, ZipEntry entry) throws FileSystemException {
        return new JarFileObject(name, entry, this, true);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(JarFileProvider.capabilities);
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            Manifest man = ((JarFile)this.getZipFile()).getManifest();
            if (man == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = man.getMainAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    Object getAttribute(Attributes.Name attrName) throws FileSystemException {
        try {
            Attributes attr = this.getAttributes();
            String value = attr.getValue(attrName);
            return value;
        }
        catch (IOException ioe) {
            throw new FileSystemException(attrName.toString(), ioe);
        }
    }

    Attributes.Name lookupName(String attrName) {
        if (Attributes.Name.CLASS_PATH.equals(attrName)) {
            return Attributes.Name.CLASS_PATH;
        }
        if (Attributes.Name.CONTENT_TYPE.equals(attrName)) {
            return Attributes.Name.CONTENT_TYPE;
        }
        if (Attributes.Name.EXTENSION_INSTALLATION.equals(attrName)) {
            return Attributes.Name.EXTENSION_INSTALLATION;
        }
        if (Attributes.Name.EXTENSION_LIST.equals(attrName)) {
            return Attributes.Name.EXTENSION_LIST;
        }
        if (Attributes.Name.EXTENSION_NAME.equals(attrName)) {
            return Attributes.Name.EXTENSION_NAME;
        }
        if (Attributes.Name.IMPLEMENTATION_TITLE.equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_TITLE;
        }
        if (Attributes.Name.IMPLEMENTATION_URL.equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_URL;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR.equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR_ID.equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR_ID;
        }
        if (Attributes.Name.IMPLEMENTATION_VERSION.equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.MAIN_CLASS.equals(attrName)) {
            return Attributes.Name.MAIN_CLASS;
        }
        if (Attributes.Name.MANIFEST_VERSION.equals(attrName)) {
            return Attributes.Name.MANIFEST_VERSION;
        }
        if (Attributes.Name.SEALED.equals(attrName)) {
            return Attributes.Name.SEALED;
        }
        if (Attributes.Name.SIGNATURE_VERSION.equals(attrName)) {
            return Attributes.Name.SIGNATURE_VERSION;
        }
        if (Attributes.Name.SPECIFICATION_TITLE.equals(attrName)) {
            return Attributes.Name.SPECIFICATION_TITLE;
        }
        if (Attributes.Name.SPECIFICATION_VENDOR.equals(attrName)) {
            return Attributes.Name.SPECIFICATION_VENDOR;
        }
        if (Attributes.Name.SPECIFICATION_VERSION.equals(attrName)) {
            return Attributes.Name.SPECIFICATION_VERSION;
        }
        return new Attributes.Name(attrName);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        Attributes.Name name = this.lookupName(attrName);
        return this.getAttribute(name);
    }

    protected ZipFile getZipFile() throws FileSystemException {
        return super.getZipFile();
    }
}

