/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram.RamFileObject;
import java.io.IOException;
import java.io.OutputStream;

public class RamFileOutputStream
extends OutputStream {
    protected RamFileObject file;
    protected byte[] buffer1 = new byte[1];
    protected boolean closed = false;
    private IOException exc;

    public RamFileOutputStream(RamFileObject file) {
        this.file = file;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int size = this.file.getData().size();
        int newSize = this.file.getData().size() + len;
        try {
            this.file.resize(newSize);
        }
        catch (IOException e) {
            this.exc = e;
            throw e;
        }
        System.arraycopy(b, off, this.file.getData().getBuffer(), size, len);
    }

    public void write(int b) throws IOException {
        this.buffer1[0] = (byte)b;
        this.write(this.buffer1);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.exc != null) {
            throw this.exc;
        }
        try {
            this.closed = true;
            this.file.endOutput();
        }
        catch (Exception e) {
            throw new FileSystemException(e);
        }
    }
}

