/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.RandomAccessContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram.RamFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.RandomAccessMode;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class RamFileRandomAccessContent
implements RandomAccessContent {
    byte[] buf;
    protected int filePointer = 0;
    private byte[] buffer8 = new byte[8];
    private byte[] buffer4 = new byte[4];
    private byte[] buffer2 = new byte[2];
    private byte[] buffer1 = new byte[1];
    private RandomAccessMode mode;
    private RamFileObject file;
    private InputStream rafis;

    public RamFileRandomAccessContent(RamFileObject file, RandomAccessMode mode) {
        this.buf = file.getData().getBuffer();
        this.file = file;
        this.mode = mode;
        this.rafis = new InputStream(){

            public int read() throws IOException {
                try {
                    return RamFileRandomAccessContent.this.readByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }

            public long skip(long n) throws IOException {
                RamFileRandomAccessContent.this.seek(RamFileRandomAccessContent.this.getFilePointer() + n);
                return n;
            }

            public void close() throws IOException {
                this.close();
            }

            public int read(byte[] b) throws IOException {
                return this.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int retLen = Math.min(len, RamFileRandomAccessContent.this.getLeftBytes());
                RamFileRandomAccessContent.this.readFully(b, off, retLen);
                return retLen;
            }

            public int available() throws IOException {
                return RamFileRandomAccessContent.this.getLeftBytes();
            }
        };
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        this.filePointer = (int)pos;
    }

    public long length() throws IOException {
        return this.buf.length;
    }

    public void close() throws IOException {
    }

    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public int readUnsignedByte() throws IOException {
        if (this.filePointer < this.buf.length) {
            return this.buf[this.filePointer++] & 0xFF;
        }
        throw new EOFException();
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toUnsignedShort(this.buffer2);
    }

    public long readLong() throws IOException {
        this.readFully(this.buffer8);
        return RamFileRandomAccessContent.toLong(this.buffer8);
    }

    public short readShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toShort(this.buffer2);
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("The skip number can't be negative");
        }
        long newPos = this.filePointer + n;
        if (newPos > (long)this.buf.length) {
            throw new IndexOutOfBoundsException("Tyring to skip too much bytes");
        }
        this.seek(newPos);
        return n;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length is lower than 0");
        }
        if (len > this.getLeftBytes()) {
            throw new IndexOutOfBoundsException("Read length (" + len + ") is higher than buffer left bytes (" + this.getLeftBytes() + ") ");
        }
        System.arraycopy(this.buf, this.filePointer, b, off, len);
        this.filePointer += len;
    }

    private int getLeftBytes() {
        return this.buf.length - this.filePointer;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.getLeftBytes() < len) {
            int newSize = this.buf.length + len - this.getLeftBytes();
            this.file.resize(newSize);
            this.buf = this.file.getData().getBuffer();
        }
        System.arraycopy(b, off, this.buf, this.filePointer, len);
        this.filePointer += len;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeByte(int i) throws IOException {
        this.write(i);
    }

    public static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(long n, byte[] b) {
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static short toShort(byte[] b) {
        return (short)RamFileRandomAccessContent.toUnsignedShort(b);
    }

    public static int toUnsignedShort(byte[] b) {
        return (b[1] & 0xFF) + ((b[0] & 0xFF) << 8);
    }

    public void write(int b) throws IOException {
        this.buffer1[0] = (byte)b;
        this.write(this.buffer1);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    public void writeChar(int v) throws IOException {
        this.buffer2[0] = (byte)(v >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v >>> 0 & 0xFF);
        this.write(this.buffer2);
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) throws IOException {
        this.buffer4[0] = (byte)(v >>> 24 & 0xFF);
        this.buffer4[1] = (byte)(v >>> 16 & 0xFF);
        this.buffer4[2] = (byte)(v >>> 8 & 0xFF);
        this.buffer4[3] = (byte)(v & 0xFF);
        this.write(this.buffer4);
    }

    public void writeLong(long v) throws IOException {
        this.write(RamFileRandomAccessContent.toBytes(v, this.buffer8));
    }

    public void writeShort(int v) throws IOException {
        this.buffer2[0] = (byte)(v >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v & 0xFF);
        this.write(this.buffer2);
    }

    public void writeUTF(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(str.length());
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(str);
        dataOut.flush();
        dataOut.close();
        byte[] b = out.toByteArray();
        this.write(b);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("deprecated");
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

