/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.url;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.url.UrlFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.url.UrlFileSystem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class UrlFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public UrlFileProvider() {
        this.setFileNameParser(new UrlFileNameParser());
    }

    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            URL url = new URL(uri);
            URL rootUrl = new URL(url, "/");
            String key = this.getClass().getName() + rootUrl.toString();
            FileSystem fs = this.findFileSystem((Comparable)((Object)key), fileSystemOptions);
            if (fs == null) {
                String extForm = rootUrl.toExternalForm();
                FileName rootName = this.getContext().parseURI(extForm);
                fs = new UrlFileSystem(rootName, fileSystemOptions);
                this.addFileSystem((Comparable)((Object)key), fs);
            }
            return fs.resolveFile(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri, (Throwable)e);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

