/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.AndroidVersion;
import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.BrokenPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IExactApiLevelDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ILayoutlibVersion;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPackageVersion;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPlatformDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.LayoutlibVersionMixin;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import com.crashlytics.reloc.com.android.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonPackage
extends Package
implements IPackageVersion,
IPlatformDependency,
IExactApiLevelDependency,
ILayoutlibVersion {
    private final String mVendorId;
    private final String mVendorDisplay;
    private final String mNameId;
    private final String mDisplayName;
    private final AndroidVersion mVersion;
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final Lib[] mLibs;

    AddonPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        int n;
        String string2 = XmlParserUtils.getXmlString(node, "name-id");
        String string3 = XmlParserUtils.getXmlString(node, "name-display");
        String string4 = XmlParserUtils.getXmlString(node, "name");
        if (string3.length() == 0) {
            string3 = string4;
        }
        if (string2.length() == 0) {
            string2 = this.sanitizeDisplayToNameId(string4.length() > 0 ? string4 : string3);
        }
        assert (string2.length() > 0);
        assert (string3.length() > 0);
        this.mNameId = string2.trim();
        this.mDisplayName = string3.trim();
        String string5 = XmlParserUtils.getXmlString(node, "vendor-id");
        String string6 = XmlParserUtils.getXmlString(node, "vendor-display");
        String string7 = XmlParserUtils.getXmlString(node, "vendor");
        if (string6.length() == 0) {
            string6 = string7;
        }
        if (string5.length() == 0) {
            n = string7.length() > 0 ? 1 : 0;
            string5 = this.sanitizeDisplayToNameId(n != 0 ? string7 : string6);
        }
        assert (string5.length() > 0);
        assert (string6.length() > 0);
        this.mVendorId = string5.trim();
        this.mVendorDisplay = string6.trim();
        n = XmlParserUtils.getXmlInt(node, "api-level", 0);
        this.mVersion = new AndroidVersion(n, null);
        this.mLibs = this.parseLibs(XmlParserUtils.getFirstChild(node, "libs"));
        this.mLayoutlibVersion = new LayoutlibVersionMixin(node);
    }

    static Package create(IAndroidTarget iAndroidTarget, Properties properties) {
        return new AddonPackage(iAndroidTarget, properties);
    }

    protected AddonPackage(IAndroidTarget iAndroidTarget, Properties properties) {
        this(null, iAndroidTarget, properties);
    }

    protected AddonPackage(SdkSource sdkSource, IAndroidTarget iAndroidTarget, Properties properties) {
        super(sdkSource, properties, iAndroidTarget.getRevision(), null, iAndroidTarget.getDescription(), null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), iAndroidTarget.getLocation());
        String string = AddonPackage.getProperty(properties, "Addon.NameId", "");
        String string2 = AddonPackage.getProperty(properties, "Addon.NameDisplay", "");
        String string3 = AddonPackage.getProperty(properties, "Addon.Name", iAndroidTarget.getName());
        if (string2.length() == 0) {
            string2 = string3;
        }
        if (string.length() == 0) {
            string = this.sanitizeDisplayToNameId(string3.length() > 0 ? string3 : string2);
        }
        assert (string.length() > 0);
        assert (string2.length() > 0);
        this.mNameId = string.trim();
        this.mDisplayName = string2.trim();
        String string4 = AddonPackage.getProperty(properties, "Addon.VendorId", "");
        String string5 = AddonPackage.getProperty(properties, "Addon.VendorDisplay", "");
        String string6 = AddonPackage.getProperty(properties, "Addon.Vendor", iAndroidTarget.getVendor());
        if (string5.length() == 0) {
            string5 = string6;
        }
        if (string4.length() == 0) {
            boolean bl = string6.length() > 0;
            string4 = this.sanitizeDisplayToNameId(bl ? string6 : string5);
        }
        assert (string4.length() > 0);
        assert (string5.length() > 0);
        this.mVendorId = string4.trim();
        this.mVendorDisplay = string5.trim();
        this.mVersion = iAndroidTarget.getVersion();
        this.mLayoutlibVersion = new LayoutlibVersionMixin(properties);
        IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray = iAndroidTarget.getOptionalLibraries();
        if (iOptionalLibraryArray == null || iOptionalLibraryArray.length == 0) {
            this.mLibs = new Lib[0];
        } else {
            this.mLibs = new Lib[iOptionalLibraryArray.length];
            for (int i = 0; i < iOptionalLibraryArray.length; ++i) {
                this.mLibs[i] = new Lib(iOptionalLibraryArray[i].getName(), iOptionalLibraryArray[i].getDescription());
            }
        }
    }

    static Package createBroken(String string, Properties properties, Map<String, String> map, String string2) {
        String string3 = AddonPackage.getProperty(properties, "Addon.NameDisplay", AddonPackage.getProperty(properties, "Addon.Name", map.get("name")));
        String string4 = AddonPackage.getProperty(properties, "Addon.VendorDisplay", AddonPackage.getProperty(properties, "Addon.Vendor", map.get("vendor")));
        String string5 = map.get("api");
        String string6 = map.get("revision");
        String string7 = String.format("%1$s by %2$s, Android API %3$s, revision %4$s [*]", string3, string4, string5, string6);
        String string8 = String.format("%1$s\n[*] Addon failed to load: %2$s", string7, string2);
        int n = 0;
        try {
            n = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new BrokenPackage(null, string7, string8, 0, n, string);
    }

    @Override
    public int getExactApiLevel() {
        return this.mVersion.getApiLevel();
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        this.mVersion.saveProperties(properties);
        this.mLayoutlibVersion.saveProperties(properties);
        properties.setProperty("Addon.NameId", this.mNameId);
        properties.setProperty("Addon.NameDisplay", this.mDisplayName);
        properties.setProperty("Addon.VendorId", this.mVendorId);
        properties.setProperty("Addon.VendorDisplay", this.mVendorDisplay);
    }

    private Lib[] parseLibs(Node node) {
        ArrayList<Lib> arrayList = new ArrayList<Lib>();
        if (node != null) {
            String string = node.getNamespaceURI();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || !"lib".equals(node2.getLocalName())) continue;
                arrayList.add(this.parseLib(node2));
            }
        }
        return arrayList.toArray(new Lib[arrayList.size()]);
    }

    private Lib parseLib(Node node) {
        return new Lib(XmlParserUtils.getXmlString(node, "name"), XmlParserUtils.getXmlString(node, "description"));
    }

    public String getVendorId() {
        return this.mVendorId;
    }

    public String getDisplayVendor() {
        return this.mVendorDisplay;
    }

    public String getNameId() {
        return this.mNameId;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    public Lib[] getLibs() {
        return this.mLibs;
    }

    @Override
    public Pair<Integer, Integer> getLayoutlibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }

    @Override
    public String installId() {
        return this.encodeAddonName();
    }

    @Override
    public String getListDescription() {
        return String.format("%1$s%2$s", this.getDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("%1$s, Android API %2$s, revision %3$s%4$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = String.format("%1$s, Android API %2$s, revision %3$s%4$s\nBy %5$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "", this.getDisplayVendor());
        String string2 = this.getDescription();
        if (string2 != null && string2.length() > 0) {
            string = string + '\n' + string2;
        }
        string = string + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        File file = new File(string, "add-ons");
        IAndroidTarget[] object = sdkManager.getTargets();
        int n = object.length;
        for (int object2 = 0; object2 < n; ++object2) {
            IAndroidTarget iAndroidTarget = object[object2];
            if (iAndroidTarget.isPlatform() || !iAndroidTarget.getVersion().equals(this.mVersion) || (!iAndroidTarget.getName().equals(this.getNameId()) || !iAndroidTarget.getVendor().equals(this.getVendorId())) && (!iAndroidTarget.getName().equals(this.getDisplayName()) || !iAndroidTarget.getVendor().equals(this.getDisplayVendor()))) continue;
            return new File(iAndroidTarget.getLocation());
        }
        String string2 = this.encodeAddonName();
        for (n = 0; n < 100; ++n) {
            String string3 = n == 0 ? string2 : String.format("%s-%d", string2, n);
            File file2 = new File(file, string3);
            if (file2.exists()) continue;
            return file2;
        }
        return null;
    }

    private String encodeAddonName() {
        String string = String.format("addon-%s-%s-%s", this.getNameId(), this.getVendorId(), this.mVersion.getApiString());
        string = string.toLowerCase(Locale.US);
        string = string.replaceAll("[^a-z0-9_-]+", "_");
        string = string.replaceAll("_+", "_");
        return string;
    }

    private String sanitizeDisplayToNameId(String string) {
        String string2 = string.toLowerCase(Locale.US);
        string2 = string2.replaceAll("[^a-z0-9_-]+", "_");
        if ((string2 = string2.replaceAll("_+", "_")).length() > 1) {
            string2 = string2.replaceAll("^_+", "");
        }
        if (string2.length() > 1) {
            string2 = string2.replaceAll("_+$", "");
        }
        return string2;
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof AddonPackage) {
            AddonPackage addonPackage = (AddonPackage)package_;
            if (this.getNameId().equals(addonPackage.getNameId()) && this.getVersion().equals(addonPackage.getVersion())) {
                if (this.getVendorId().equals(addonPackage.getVendorId())) {
                    return true;
                }
                return this.getDisplayVendor().equals(addonPackage.getDisplayVendor());
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        n = 31 * n + Arrays.hashCode(this.mLibs);
        n = 31 * n + (this.mDisplayName == null ? 0 : this.mDisplayName.hashCode());
        n = 31 * n + (this.mVendorDisplay == null ? 0 : this.mVendorDisplay.hashCode());
        n = 31 * n + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AddonPackage)) {
            return false;
        }
        AddonPackage addonPackage = (AddonPackage)object;
        if (this.mLayoutlibVersion == null ? addonPackage.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(addonPackage.mLayoutlibVersion)) {
            return false;
        }
        if (!Arrays.equals(this.mLibs, addonPackage.mLibs)) {
            return false;
        }
        if (this.mNameId == null ? addonPackage.mNameId != null : !this.mNameId.equals(addonPackage.mNameId)) {
            return false;
        }
        if (this.mVendorId == null ? addonPackage.mVendorId != null : !this.mVendorId.equals(addonPackage.mVendorId)) {
            return false;
        }
        return !(this.mVersion == null ? addonPackage.mVersion != null : !this.mVersion.equals(addonPackage.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String string = super.comparisonKey();
        int n = string.indexOf("|r:");
        assert (n > 0);
        string = string.substring(0, n) + "|vid:" + this.getVendorId() + "|nid:" + this.getNameId() + string.substring(n);
        return string;
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String string, String string2) {
            this.mName = string;
            this.mDescription = string2;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.mDescription == null ? 0 : this.mDescription.hashCode());
            n = 31 * n + (this.mName == null ? 0 : this.mName.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Lib)) {
                return false;
            }
            Lib lib = (Lib)object;
            if (this.mDescription == null ? lib.mDescription != null : !this.mDescription.equals(lib.mDescription)) {
                return false;
            }
            return !(this.mName == null ? lib.mName != null : !this.mName.equals(lib.mName));
        }
    }
}

