/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.client.protocol;

import com.crashlytics.reloc.org.apache.commons.logging.Log;
import com.crashlytics.reloc.org.apache.commons.logging.LogFactory;
import com.crashlytics.reloc.org.apache.http.HttpException;
import com.crashlytics.reloc.org.apache.http.HttpRequest;
import com.crashlytics.reloc.org.apache.http.HttpRequestInterceptor;
import com.crashlytics.reloc.org.apache.http.annotation.Immutable;
import com.crashlytics.reloc.org.apache.http.client.protocol.HttpClientContext;
import com.crashlytics.reloc.org.apache.http.conn.routing.RouteInfo;
import com.crashlytics.reloc.org.apache.http.protocol.HttpContext;
import com.crashlytics.reloc.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

