/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.impl.execchain;

import com.crashlytics.reloc.org.apache.commons.logging.Log;
import com.crashlytics.reloc.org.apache.commons.logging.LogFactory;
import com.crashlytics.reloc.org.apache.http.Header;
import com.crashlytics.reloc.org.apache.http.HttpException;
import com.crashlytics.reloc.org.apache.http.annotation.Immutable;
import com.crashlytics.reloc.org.apache.http.client.HttpRequestRetryHandler;
import com.crashlytics.reloc.org.apache.http.client.NonRepeatableRequestException;
import com.crashlytics.reloc.org.apache.http.client.methods.CloseableHttpResponse;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpExecutionAware;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpRequestWrapper;
import com.crashlytics.reloc.org.apache.http.client.protocol.HttpClientContext;
import com.crashlytics.reloc.org.apache.http.conn.routing.HttpRoute;
import com.crashlytics.reloc.org.apache.http.impl.execchain.ClientExecChain;
import com.crashlytics.reloc.org.apache.http.impl.execchain.Proxies;
import com.crashlytics.reloc.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryHandler, "HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route, request, context, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    this.log.debug("Request has been aborted");
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, context)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ex.getMessage(), ex);
                    }
                    if (!Proxies.isRepeatable(request)) {
                        this.log.debug("Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", ex);
                    }
                } else {
                    throw ex;
                }
                request.setHeaders(origheaders);
                this.log.info("Retrying request");
                ++execCount;
                continue;
            }
            break;
        }
    }
}

