/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.event;

import com.crashlytics.reloc.org.apache.ivy.core.event.FilteredIvyListener;
import com.crashlytics.reloc.org.apache.ivy.core.event.IvyEvent;
import com.crashlytics.reloc.org.apache.ivy.core.event.IvyEventFilter;
import com.crashlytics.reloc.org.apache.ivy.core.event.IvyListener;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.TransferEvent;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.TransferListener;
import com.crashlytics.reloc.org.apache.ivy.util.filter.Filter;
import java.util.Arrays;
import javax.swing.event.EventListenerList;

public class EventManager
implements TransferListener {
    private EventListenerList listeners = new EventListenerList();

    public void addIvyListener(IvyListener listener) {
        this.listeners.add(IvyListener.class, listener);
    }

    public void addIvyListener(IvyListener listener, String eventName) {
        this.addIvyListener(listener, new IvyEventFilter(eventName, null, null));
    }

    public void addIvyListener(IvyListener listener, Filter filter) {
        this.listeners.add(IvyListener.class, new FilteredIvyListener(listener, filter));
    }

    public void removeIvyListener(IvyListener listener) {
        this.listeners.remove(IvyListener.class, listener);
        IvyListener[] listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof FilteredIvyListener) || !listener.equals(((FilteredIvyListener)listeners[i]).getIvyListener())) continue;
            this.listeners.remove(IvyListener.class, listeners[i]);
        }
    }

    public boolean hasIvyListener(IvyListener listener) {
        return Arrays.asList(this.listeners.getListeners(IvyListener.class)).contains(listener);
    }

    public void fireIvyEvent(IvyEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IvyListener.class) continue;
            ((IvyListener)listeners[i + 1]).progress(evt);
        }
    }

    public void addTransferListener(TransferListener listener) {
        this.listeners.add(TransferListener.class, listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.listeners.remove(TransferListener.class, listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return Arrays.asList(this.listeners.getListeners(TransferListener.class)).contains(listener);
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransferListener.class) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    public void transferProgress(TransferEvent evt) {
        this.fireTransferEvent(evt);
        this.fireIvyEvent(evt);
    }
}

