/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.module.descriptor;

import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Configuration;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ExcludeRule;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.License;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.MDArtifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ArtifactId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRules;
import com.crashlytics.reloc.org.apache.ivy.core.module.status.StatusManager;
import com.crashlytics.reloc.org.apache.ivy.plugins.conflict.ConflictManager;
import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.MapMatcher;
import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.MatcherHelper;
import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.PatternMatcher;
import com.crashlytics.reloc.org.apache.ivy.plugins.namespace.NameSpaceHelper;
import com.crashlytics.reloc.org.apache.ivy.plugins.namespace.Namespace;
import com.crashlytics.reloc.org.apache.ivy.plugins.namespace.NamespaceTransformer;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.version.VersionMatcher;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleDescriptor
implements ModuleDescriptor {
    private ModuleRevisionId revId;
    private ModuleRevisionId resolvedRevId;
    private String status = StatusManager.getCurrent().getDefaultStatus();
    private Date publicationDate;
    private Date resolvedPublicationDate;
    private List dependencies = new ArrayList();
    private Map configurations = new LinkedHashMap();
    private Map artifactsByConf = new HashMap();
    private Collection artifacts = new LinkedHashSet();
    private boolean isDefault = false;
    private ModuleRules conflictManagers = new ModuleRules();
    private ModuleRules dependencyDescriptorMediators = new ModuleRules();
    private List licenses = new ArrayList();
    private String homePage;
    private String description = "";
    private long lastModified = 0L;
    private Namespace namespace;
    private String defaultConf;
    private String defaultConfMapping;
    private boolean mappingOverride;
    private ModuleDescriptorParser parser;
    private Resource resource;
    private List excludeRules = new ArrayList();
    private Artifact metadataArtifact;
    private List inheritedDescriptors = new ArrayList();
    private Map extraAttributesNamespaces = new LinkedHashMap();
    private List<ExtraInfoHolder> extraInfos = new ArrayList<ExtraInfoHolder>();

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid) {
        return DefaultModuleDescriptor.newDefaultInstance(mrid, null);
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId mrid, String[] confs, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName() + "-caller", "working"), "integration", null, true);
        for (int i = 0; i < confs.length; ++i) {
            moduleDescriptor.addConfiguration(new Configuration(confs[i]));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid, true, changing, transitive);
        for (int j = 0; j < confs.length; ++j) {
            dd.addDependencyConfiguration(confs[j], confs[j]);
        }
        moduleDescriptor.addDependency(dd);
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId[] mrid, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("caller", "all-caller", "working"), "integration", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        for (int i = 0; i < mrid.length; ++i) {
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid[i], true, changing, transitive);
            dd.addDependencyConfiguration("default", "*");
            moduleDescriptor.addDependency(dd);
        }
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid, DependencyArtifactDescriptor[] artifacts) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        if (artifacts != null && artifacts.length > 0) {
            for (int i = 0; i < artifacts.length; ++i) {
                moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, artifacts[i].getName(), artifacts[i].getType(), artifacts[i].getExt(), artifacts[i].getUrl(), artifacts[i].getExtraAttributes()));
            }
        } else {
            moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newBasicInstance(ModuleRevisionId mrid, Date publicationDate) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", publicationDate, false);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        return moduleDescriptor;
    }

    public static ModuleDescriptor transformInstance(ModuleDescriptor md, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return md;
        }
        DefaultModuleDescriptor nmd = new DefaultModuleDescriptor(md.getParser(), md.getResource());
        nmd.revId = t.transform(md.getModuleRevisionId());
        nmd.resolvedRevId = t.transform(md.getResolvedModuleRevisionId());
        nmd.status = md.getStatus();
        nmd.publicationDate = md.getPublicationDate();
        nmd.resolvedPublicationDate = md.getResolvedPublicationDate();
        ExtendsDescriptor[] ed = md.getInheritedDescriptors();
        for (int i = 0; i < ed.length; ++i) {
            ModuleDescriptor parentMd = ed[i].getParentMd();
            DefaultModuleDescriptor parentNmd = new DefaultModuleDescriptor(parentMd.getParser(), parentMd.getResource());
            parentNmd.revId = t.transform(parentMd.getModuleRevisionId());
            parentNmd.resolvedRevId = t.transform(parentMd.getResolvedModuleRevisionId());
            parentNmd.status = parentMd.getStatus();
            parentNmd.publicationDate = parentMd.getPublicationDate();
            parentNmd.resolvedPublicationDate = parentMd.getResolvedPublicationDate();
            nmd.inheritedDescriptors.add(new DefaultExtendsDescriptor(parentNmd, ed[i].getLocation(), ed[i].getExtendsTypes()));
        }
        DependencyDescriptor[] dd = md.getDependencies();
        for (int i = 0; i < dd.length; ++i) {
            nmd.dependencies.add(NameSpaceHelper.toSystem(dd[i], ns));
        }
        Configuration[] confs = md.getConfigurations();
        for (int i = 0; i < confs.length; ++i) {
            nmd.configurations.put(confs[i].getName(), confs[i]);
            Artifact[] arts = md.getArtifacts(confs[i].getName());
            for (int j = 0; j < arts.length; ++j) {
                nmd.addArtifact(confs[i].getName(), NameSpaceHelper.transform(arts[j], t));
            }
        }
        nmd.setDefault(md.isDefault());
        if (md instanceof DefaultModuleDescriptor) {
            DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
            nmd.conflictManagers = (ModuleRules)dmd.conflictManagers.clone();
            nmd.dependencyDescriptorMediators = (ModuleRules)dmd.dependencyDescriptorMediators.clone();
        } else {
            Message.warn("transformed module descriptor is not a default module descriptor: impossible to copy conflict manager and version mediation configuration: " + md);
        }
        nmd.licenses.addAll(Arrays.asList(md.getLicenses()));
        nmd.homePage = md.getHomePage();
        nmd.description = md.getDescription();
        nmd.lastModified = md.getLastModified();
        nmd.extraAttributesNamespaces = md.getExtraAttributesNamespaces();
        nmd.extraInfos = md.getExtraInfos();
        nmd.namespace = ns;
        return nmd;
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate) {
        this(id, status, pubDate, false);
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate, boolean isDefault) {
        if (id == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        if (status == null) {
            throw new NullPointerException("null status not allowed");
        }
        this.revId = id;
        this.resolvedRevId = id;
        this.status = status;
        this.publicationDate = pubDate;
        this.resolvedPublicationDate = this.publicationDate == null ? new Date() : this.publicationDate;
        this.isDefault = isDefault;
        this.parser = XmlModuleDescriptorParser.getInstance();
    }

    public DefaultModuleDescriptor(ModuleDescriptorParser parser, Resource res) {
        this.parser = parser;
        this.resource = res;
    }

    @Override
    public Artifact getMetadataArtifact() {
        if (this.metadataArtifact == null) {
            this.metadataArtifact = DefaultArtifact.newIvyArtifact(this.resolvedRevId, this.resolvedPublicationDate);
        }
        return this.metadataArtifact;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.metadataArtifact = moduleArtifact;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
        if (this.resolvedPublicationDate == null) {
            this.resolvedPublicationDate = publicationDate == null ? new Date() : publicationDate;
        }
    }

    @Override
    public Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public void setResolvedPublicationDate(Date publicationDate) {
        if (publicationDate == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        this.resolvedPublicationDate = publicationDate;
    }

    @Override
    public Date getResolvedPublicationDate() {
        return this.resolvedPublicationDate;
    }

    @Override
    public String getRevision() {
        return this.getResolvedModuleRevisionId().getRevision();
    }

    public void setModuleRevisionId(ModuleRevisionId revId) {
        if (revId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        this.revId = revId;
        if (this.resolvedRevId == null) {
            this.resolvedRevId = revId;
        }
    }

    @Override
    public void setResolvedModuleRevisionId(ModuleRevisionId revId) {
        this.resolvedRevId = revId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void addInheritedDescriptor(ExtendsDescriptor descriptor) {
        this.inheritedDescriptors.add(descriptor);
    }

    public void addDependency(DependencyDescriptor dependency) {
        this.dependencies.add(dependency);
    }

    public void addConfiguration(Configuration conf) {
        this.configurations.put(conf.getName(), conf);
    }

    public void addArtifact(String conf, Artifact artifact) {
        Configuration c = this.getConfiguration(conf);
        if (c == null) {
            throw new IllegalArgumentException("Cannot add artifact '" + artifact.getId().getArtifactId().getShortDescription() + "' to configuration '" + conf + "' of module " + this.revId + " because this configuration doesn't exist!");
        }
        if (c instanceof ConfigurationGroup) {
            ConfigurationGroup group = (ConfigurationGroup)c;
            String[] members = group.getMembersConfigurationNames();
            for (int i = 0; i < members.length; ++i) {
                this.addArtifact(members[i], artifact);
            }
        } else {
            ArrayList<Artifact> artifacts = (ArrayList<Artifact>)this.artifactsByConf.get(conf);
            if (artifacts == null) {
                artifacts = new ArrayList<Artifact>();
                this.artifactsByConf.put(conf, artifacts);
            }
            artifacts.add(artifact);
            this.artifacts.add(artifact);
        }
    }

    @Override
    public ModuleRevisionId getModuleRevisionId() {
        return this.revId;
    }

    @Override
    public ModuleRevisionId getResolvedModuleRevisionId() {
        return this.resolvedRevId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public ExtendsDescriptor[] getInheritedDescriptors() {
        return this.inheritedDescriptors.toArray(new ExtendsDescriptor[this.inheritedDescriptors.size()]);
    }

    @Override
    public Configuration[] getConfigurations() {
        return this.configurations.values().toArray(new Configuration[this.configurations.size()]);
    }

    @Override
    public String[] getConfigurationsNames() {
        return this.configurations.keySet().toArray(new String[this.configurations.size()]);
    }

    @Override
    public String[] getPublicConfigurationsNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Configuration conf : this.configurations.values()) {
            if (conf.getVisibility() != Configuration.Visibility.PUBLIC) continue;
            ret.add(conf.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public Configuration getConfiguration(String confName) {
        Configuration configuration = (Configuration)this.configurations.get(confName);
        if (configuration == null && confName != null) {
            Matcher m = Pattern.compile("\\*\\[([^=]+)\\=([^\\]]+)\\]").matcher(confName);
            if (m.matches()) {
                String attName = m.group(1);
                String attValue = m.group(2);
                LinkedHashMap<String, Configuration> members = new LinkedHashMap<String, Configuration>();
                for (Configuration conf : this.configurations.values()) {
                    if (!attValue.equals(conf.getAttribute(attName))) continue;
                    members.put(conf.getName(), conf);
                }
                return new ConfigurationGroup(confName, members);
            }
            String[] confs = confName.split("\\+");
            if (confs.length <= 1) {
                return null;
            }
            LinkedHashMap<String, Configuration> intersectedConfs = new LinkedHashMap<String, Configuration>();
            for (int i = 0; i < confs.length; ++i) {
                Configuration c = (Configuration)this.configurations.get(confs[i]);
                if (c == null) {
                    Message.verbose("missing configuration '" + confs[i] + "' from intersection " + confName + " in " + this);
                    return null;
                }
                intersectedConfs.put(confs[i], c);
            }
            return new ConfigurationIntersection(confName, intersectedConfs);
        }
        return configuration;
    }

    @Override
    public Artifact[] getArtifacts(String conf) {
        Configuration c = this.getConfiguration(conf);
        if (c == null) {
            return new Artifact[0];
        }
        Collection artifacts = (Collection)this.artifactsByConf.get(conf);
        if (c instanceof ConfigurationIntersection) {
            ConfigurationIntersection intersection = (ConfigurationIntersection)c;
            String[] intersected = intersection.getIntersectedConfigurationNames();
            LinkedHashSet intersectedArtifacts = new LinkedHashSet();
            for (int j = 0; j < intersected.length; ++j) {
                Collection arts = this.getArtifactsIncludingExtending(intersected[j]);
                if (intersectedArtifacts.isEmpty()) {
                    intersectedArtifacts.addAll(arts);
                    continue;
                }
                intersectedArtifacts.retainAll(arts);
            }
            if (artifacts != null) {
                intersectedArtifacts.addAll(artifacts);
            }
            return intersectedArtifacts.toArray(new Artifact[intersectedArtifacts.size()]);
        }
        if (c instanceof ConfigurationGroup) {
            ConfigurationGroup group = (ConfigurationGroup)c;
            String[] members = group.getMembersConfigurationNames();
            LinkedHashSet groupArtifacts = new LinkedHashSet();
            for (int i = 0; i < members.length; ++i) {
                groupArtifacts.addAll(this.getArtifactsIncludingExtending(members[i]));
            }
            if (artifacts != null) {
                groupArtifacts.addAll(artifacts);
            }
            return groupArtifacts.toArray(new Artifact[groupArtifacts.size()]);
        }
        if (artifacts == null) {
            return new Artifact[0];
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private Collection getArtifactsIncludingExtending(String conf) {
        Collection extendingConfs = Configuration.findConfigurationExtending(conf, this.getConfigurations());
        LinkedHashSet artifacts = new LinkedHashSet();
        Collection arts = (Collection)this.artifactsByConf.get(conf);
        if (arts != null) {
            artifacts.addAll(arts);
        }
        for (Configuration extendingConf : extendingConfs) {
            arts = (Collection)this.artifactsByConf.get(extendingConf.getName());
            if (arts == null) continue;
            artifacts.addAll(arts);
        }
        return artifacts;
    }

    @Override
    public Artifact[] getAllArtifacts() {
        return this.artifacts.toArray(new Artifact[this.artifacts.size()]);
    }

    @Override
    public DependencyDescriptor[] getDependencies() {
        return this.dependencies.toArray(new DependencyDescriptor[this.dependencies.size()]);
    }

    @Override
    public boolean dependsOn(VersionMatcher matcher, ModuleDescriptor md) {
        for (DependencyDescriptor dd : this.dependencies) {
            if (!dd.getDependencyId().equals(md.getModuleRevisionId().getModuleId())) continue;
            if (md.getResolvedModuleRevisionId().getRevision() == null) {
                return true;
            }
            if (!matcher.accept(dd.getDependencyRevisionId(), md)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toIvyFile(File destFile) throws ParseException, IOException {
        if (this.parser != null && this.resource != null) {
            this.parser.toIvyFile(this.resource.openStream(), this.resource, destFile, this);
        } else {
            XmlModuleDescriptorWriter.write(this, destFile);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.revId == null ? 0 : this.revId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultModuleDescriptor other = (DefaultModuleDescriptor)obj;
        return !(this.revId == null ? other.revId != null : !this.revId.equals(other.revId));
    }

    public String toString() {
        return "module: " + this.revId + " status=" + this.status + " publication=" + this.publicationDate + " configurations=" + this.configurations + " artifacts=" + this.artifactsByConf + " dependencies=" + this.dependencies;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public void addConflictManager(ModuleId moduleId, PatternMatcher matcher, ConflictManager manager) {
        this.conflictManagers.defineRule(new MapMatcher(moduleId.getAttributes(), matcher), manager);
    }

    @Override
    public ConflictManager getConflictManager(ModuleId moduleId) {
        return (ConflictManager)this.conflictManagers.getRule(moduleId);
    }

    public void addDependencyDescriptorMediator(ModuleId moduleId, PatternMatcher matcher, DependencyDescriptorMediator ddm) {
        this.dependencyDescriptorMediators.defineRule(new MapMatcher(moduleId.getAttributes(), matcher), ddm);
    }

    @Override
    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        Object[] mediators = this.dependencyDescriptorMediators.getRules(dd.getDependencyId());
        for (int i = 0; i < mediators.length; ++i) {
            dd = ((DependencyDescriptorMediator)mediators[i]).mediate(dd);
        }
        return dd;
    }

    @Override
    public ModuleRules getAllDependencyDescriptorMediators() {
        return (ModuleRules)this.dependencyDescriptorMediators.clone();
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    @Override
    public License[] getLicenses() {
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    @Override
    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isNamespaceUseful() {
        for (DependencyDescriptor dd : this.dependencies) {
            if (dd.getAllExcludeRules().length <= 0) continue;
            return true;
        }
        return false;
    }

    public void setNamespace(Namespace ns) {
        this.namespace = ns;
    }

    public void check() {
        Stack<String> confs = new Stack<String>();
        for (Configuration conf : this.configurations.values()) {
            String[] ext = conf.getExtends();
            for (int i = 0; i < ext.length; ++i) {
                confs.push(conf.getName());
                this.checkConf(confs, ext[i].trim());
                confs.pop();
            }
        }
    }

    private void checkConf(Stack confs, String confName) {
        int index = confs.indexOf(confName);
        if (index != -1) {
            StringBuffer cycle = new StringBuffer();
            while (index < confs.size()) {
                cycle.append(confs.get(index)).append(" => ");
                ++index;
            }
            cycle.append(confName);
            throw new IllegalStateException("illegal cycle detected in configuration extension: " + cycle);
        }
        Configuration conf = this.getConfiguration(confName);
        if (conf == null) {
            throw new IllegalStateException("unknown configuration '" + confName + "'. It is extended by " + confs.get(confs.size() - 1));
        }
        String[] ext = conf.getExtends();
        for (int i = 0; i < ext.length; ++i) {
            confs.push(conf.getName());
            this.checkConf(confs, ext[i].trim());
            confs.pop();
        }
    }

    public String getDefaultConf() {
        return this.defaultConf;
    }

    public void setDefaultConf(String defaultConf) {
        this.defaultConf = defaultConf;
    }

    public String getDefaultConfMapping() {
        return this.defaultConfMapping;
    }

    public void setDefaultConfMapping(String defaultConfMapping) {
        this.defaultConfMapping = defaultConfMapping;
    }

    public void setMappingOverride(boolean override) {
        this.mappingOverride = override;
    }

    public boolean isMappingOverride() {
        return this.mappingOverride;
    }

    @Override
    public String getAttribute(String attName) {
        return this.resolvedRevId.getAttribute(attName);
    }

    @Override
    public Map getAttributes() {
        return this.resolvedRevId.getAttributes();
    }

    @Override
    public String getExtraAttribute(String attName) {
        return this.resolvedRevId.getExtraAttribute(attName);
    }

    @Override
    public Map getExtraAttributes() {
        return this.resolvedRevId.getExtraAttributes();
    }

    @Override
    public Map getQualifiedExtraAttributes() {
        return this.resolvedRevId.getQualifiedExtraAttributes();
    }

    @Override
    public ModuleDescriptorParser getParser() {
        return this.parser;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public void addExcludeRule(ExcludeRule rule) {
        this.excludeRules.add(rule);
    }

    @Override
    public boolean canExclude() {
        return !this.excludeRules.isEmpty();
    }

    @Override
    public boolean doesExclude(String[] moduleConfigurations, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        ExcludeRule[] rules = this.getExcludeRules(moduleConfigurations);
        for (int i = 0; i < rules.length; ++i) {
            if (!MatcherHelper.matches(rules[i].getMatcher(), rules[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExcludeRule[] getAllExcludeRules() {
        return this.excludeRules.toArray(new ExcludeRule[this.excludeRules.size()]);
    }

    public ExcludeRule[] getExcludeRules(String[] moduleConfigurations) {
        LinkedHashSet<ExcludeRule> rules = new LinkedHashSet<ExcludeRule>();
        for (ExcludeRule rule : this.excludeRules) {
            String[] ruleConfs = rule.getConfigurations();
            if (!this.containsAny(ruleConfs, moduleConfigurations)) continue;
            rules.add(rule);
        }
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    private boolean containsAny(String[] arr1, String[] arr2) {
        return new ArrayList<String>(Arrays.asList(arr1)).removeAll(Arrays.asList(arr2));
    }

    public Map getExtraAttributesNamespaces() {
        return this.extraAttributesNamespaces;
    }

    public void addExtraAttributeNamespace(String prefix, String namespace) {
        this.extraAttributesNamespaces.put(prefix, namespace);
    }

    @Deprecated
    public void addExtraInfo(String infoKey, String value) {
        this.extraInfos.add(new ExtraInfoHolder(infoKey, value));
    }

    @Override
    @Deprecated
    public Map<String, String> getExtraInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ExtraInfoHolder extraInfo : this.extraInfos) {
            this.populateExtraInfoMap(map, extraInfo);
        }
        return map;
    }

    private void populateExtraInfoMap(Map<String, String> map, ExtraInfoHolder extraInfo) {
        map.put(extraInfo.getName(), extraInfo.getContent());
        for (ExtraInfoHolder nested : extraInfo.getNestedExtraInfoHolder()) {
            this.populateExtraInfoMap(map, nested);
        }
    }

    @Override
    public List<ExtraInfoHolder> getExtraInfos() {
        return this.extraInfos;
    }

    public void addExtraInfo(ExtraInfoHolder extraInfo) {
        this.extraInfos.add(extraInfo);
    }

    @Override
    public String getExtraInfoContentByTagName(String tagName) {
        ExtraInfoHolder extraInfoByTagName = this.getExtraInfoByTagName(tagName);
        if (extraInfoByTagName != null) {
            return extraInfoByTagName.getContent();
        }
        return null;
    }

    @Override
    public ExtraInfoHolder getExtraInfoByTagName(String tagName) {
        for (ExtraInfoHolder extraInfoHolder : this.extraInfos) {
            if (!extraInfoHolder.getName().equals(tagName)) continue;
            return extraInfoHolder;
        }
        return null;
    }
}

