/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.report;

import com.crashlytics.reloc.org.apache.ivy.core.cache.ResolutionCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadStatus;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveEngine;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveOptions;
import com.crashlytics.reloc.org.apache.ivy.core.sort.SortOptions;
import com.crashlytics.reloc.org.apache.ivy.plugins.report.XmlReportParser;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationResolveReport {
    private final ModuleDescriptor md;
    private final String conf;
    private final Date date;
    private final ResolveOptions options;
    private Map<IvyNode, List<ArtifactDownloadReport>> dependencyReports = new LinkedHashMap<IvyNode, List<ArtifactDownloadReport>>();
    private Map<ModuleRevisionId, IvyNode> dependencies = new LinkedHashMap<ModuleRevisionId, IvyNode>();
    private final ResolveEngine resolveEngine;
    private Map<ModuleId, Collection<IvyNode>> modulesIdsMap = new LinkedHashMap<ModuleId, Collection<IvyNode>>();
    private List<ModuleId> modulesIds;
    private Boolean hasChanged = null;

    public ConfigurationResolveReport(ResolveEngine resolveEngine, ModuleDescriptor md, String conf, Date date, ResolveOptions options) {
        this.resolveEngine = resolveEngine;
        this.md = md;
        this.conf = conf;
        this.date = date;
        this.options = options;
    }

    public void checkIfChanged() {
        String resolveId;
        ResolutionCacheManager cache = this.resolveEngine.getSettings().getResolutionCacheManager();
        File previousReportFile = cache.getConfigurationResolveReportInCache(resolveId = this.options.getResolveId(), this.conf);
        if (previousReportFile.exists()) {
            try {
                XmlReportParser parser = new XmlReportParser();
                parser.parse(previousReportFile);
                List<ModuleRevisionId> previousDeps = Arrays.asList(parser.getDependencyRevisionIds());
                HashSet<ModuleRevisionId> previousDepSet = new HashSet<ModuleRevisionId>(previousDeps);
                this.hasChanged = !previousDepSet.equals(this.getModuleRevisionIds());
            }
            catch (Exception e) {
                Message.warn("Error while parsing configuration resolve report " + previousReportFile.getAbsolutePath(), e);
                this.hasChanged = Boolean.TRUE;
            }
        } else {
            this.hasChanged = Boolean.TRUE;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public Set<ModuleRevisionId> getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> mrids = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode node : this.getDependencies()) {
            if (node.isEvicted(this.getConfiguration()) || node.hasProblem()) continue;
            mrids.add(node.getResolvedId());
        }
        return mrids;
    }

    public void addDependency(IvyNode node) {
        this.dependencies.put(node.getId(), node);
        this.dependencies.put(node.getResolvedId(), node);
        this.dependencyReports.put(node, Collections.emptyList());
    }

    public void updateDependency(ModuleRevisionId mrid, IvyNode node) {
        this.dependencies.put(mrid, node);
    }

    public void addDependency(IvyNode node, DownloadReport report) {
        Artifact[] artifacts;
        this.dependencies.put(node.getId(), node);
        this.dependencies.put(node.getResolvedId(), node);
        ArrayList<ArtifactDownloadReport> adrs = new ArrayList<ArtifactDownloadReport>();
        for (Artifact artifact : artifacts = node.getArtifacts(this.conf)) {
            ArtifactDownloadReport artifactReport = report.getArtifactReport(artifact);
            if (artifactReport != null) {
                adrs.add(artifactReport);
                continue;
            }
            Message.debug("no report found for " + artifact);
        }
        this.dependencyReports.put(node, adrs);
    }

    public String getConfiguration() {
        return this.conf;
    }

    public Date getDate() {
        return this.date;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> unresolved = new ArrayList<IvyNode>();
        for (IvyNode node : this.getDependencies()) {
            if (!node.hasProblem()) continue;
            unresolved.add(node);
        }
        return unresolved.toArray(new IvyNode[unresolved.size()]);
    }

    private Collection<IvyNode> getDependencies() {
        return new LinkedHashSet<IvyNode>(this.dependencies.values());
    }

    public IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> evicted = new ArrayList<IvyNode>();
        for (IvyNode node : this.getDependencies()) {
            if (!node.isEvicted(this.conf)) continue;
            evicted.add(node);
        }
        return evicted.toArray(new IvyNode[evicted.size()]);
    }

    private Set<ModuleRevisionId> getEvictedMrids() {
        IvyNode[] evictedNodes;
        LinkedHashSet<ModuleRevisionId> evicted = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode node : evictedNodes = this.getEvictedNodes()) {
            evicted.add(node.getId());
        }
        return evicted;
    }

    public IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        for (IvyNode node : this.getDependencies()) {
            if (!node.isDownloaded() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        for (IvyNode node : this.getDependencies()) {
            if (!node.isSearched() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId mrid) {
        Collection col = this.dependencyReports.get(this.getDependency(mrid));
        if (col == null) {
            return new ArtifactDownloadReport[0];
        }
        return col.toArray(new ArtifactDownloadReport[col.size()]);
    }

    public IvyNode getDependency(ModuleRevisionId mrid) {
        return this.dependencies.get(mrid);
    }

    public List<ModuleId> getModuleIds() {
        if (this.modulesIds == null) {
            List<IvyNode> sortedDependencies = this.resolveEngine.getSortEngine().sortNodes(this.getDependencies(), SortOptions.SILENT);
            Collections.reverse(sortedDependencies);
            for (IvyNode dependency : sortedDependencies) {
                ModuleId mid = dependency.getResolvedId().getModuleId();
                Collection<IvyNode> deps = this.modulesIdsMap.get(mid);
                if (deps == null) {
                    deps = new LinkedHashSet<IvyNode>();
                    this.modulesIdsMap.put(mid, deps);
                }
                deps.add(dependency);
            }
            this.modulesIds = new ArrayList<ModuleId>(this.modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this.modulesIds);
    }

    public Collection<IvyNode> getNodes(ModuleId mid) {
        if (this.modulesIds == null) {
            this.getModuleIds();
        }
        return this.modulesIdsMap.get(mid);
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public int getArtifactsNumber() {
        int total = 0;
        for (List<ArtifactDownloadReport> reports : this.dependencyReports.values()) {
            total += reports == null ? 0 : reports.size();
        }
        return total;
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        Set<ModuleRevisionId> evictedMrids = null;
        if (!withEvicted) {
            evictedMrids = this.getEvictedMrids();
        }
        for (List<ArtifactDownloadReport> reports : this.dependencyReports.values()) {
            for (ArtifactDownloadReport report : reports) {
                if (downloadStatus != null && report.getDownloadStatus() != downloadStatus || !withEvicted && evictedMrids.contains(report.getArtifact().getModuleRevisionId())) continue;
                all.add(report);
            }
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        return this.getArtifactsReports(DownloadStatus.SUCCESSFUL, true);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        ArtifactDownloadReport[] allFailedReports = this.getArtifactsReports(DownloadStatus.FAILED, true);
        return ConfigurationResolveReport.filterOutMergedArtifacts(allFailedReports);
    }

    public boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public int getNodesNumber() {
        return this.getDependencies().size();
    }

    public static ArtifactDownloadReport[] filterOutMergedArtifacts(ArtifactDownloadReport[] allFailedReports) {
        ArrayList<ArtifactDownloadReport> adrs = new ArrayList<ArtifactDownloadReport>(Arrays.asList(allFailedReports));
        Iterator iterator = adrs.iterator();
        while (iterator.hasNext()) {
            ArtifactDownloadReport adr = (ArtifactDownloadReport)iterator.next();
            if (adr.getArtifact().getExtraAttribute("ivy:merged") == null) continue;
            iterator.remove();
        }
        return adrs.toArray(new ArtifactDownloadReport[adrs.size()]);
    }
}

