/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.report;

import com.crashlytics.reloc.org.apache.ivy.core.cache.ResolutionCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Configuration;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.ConfigurationResolveReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadStatus;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveOptions;
import com.crashlytics.reloc.org.apache.ivy.core.settings.IvySettings;
import com.crashlytics.reloc.org.apache.ivy.plugins.report.ReportOutputter;
import com.crashlytics.reloc.org.apache.ivy.util.filter.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveReport {
    private ModuleDescriptor md;
    private Map confReports = new LinkedHashMap();
    private List problemMessages = new ArrayList();
    private List dependencies = new ArrayList();
    private List artifacts = new ArrayList();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor md) {
        this(md, ResolveOptions.getDefaultResolveId(md));
    }

    public ResolveReport(ModuleDescriptor md, String resolveId) {
        this.md = md;
        this.resolveId = resolveId;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this.confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return (ConfigurationResolveReport)this.confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public boolean hasError() {
        boolean hasError;
        ConfigurationResolveReport report;
        Iterator it = this.confReports.values().iterator();
        for (hasError = false; it.hasNext() && !hasError; hasError |= report.hasError()) {
            report = (ConfigurationResolveReport)it.next();
        }
        return hasError;
    }

    public void output(ReportOutputter[] outputters, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        for (int i = 0; i < outputters.length; ++i) {
            outputters[i].output(this, cacheMgr, options);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            ArtifactDownloadReport[] reports = report.getArtifactsReports(downloadStatus, withEvicted);
            all.addAll(Arrays.asList(reports));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public ArtifactDownloadReport[] getArtifactsReports(ModuleRevisionId mrid) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getDownloadReports(mrid)));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public void checkIfChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            report.checkIfChanged();
        }
    }

    public boolean hasChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            if (!report.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setProblemMessages(List problems) {
        this.problemMessages = problems;
    }

    public List getProblemMessages() {
        return this.problemMessages;
    }

    public List getAllProblemMessages() {
        ArrayList<String> ret = new ArrayList<String>(this.problemMessages);
        for (ConfigurationResolveReport r : this.confReports.values()) {
            IvyNode[] unresolved = r.getUnresolvedDependencies();
            for (int i = 0; i < unresolved.length; ++i) {
                String errMsg = unresolved[i].getProblemMessage();
                if (errMsg.length() > 0) {
                    ret.add("unresolved dependency: " + unresolved[i].getId() + ": " + errMsg);
                    continue;
                }
                ret.add("unresolved dependency: " + unresolved[i].getId());
            }
            ArtifactDownloadReport[] adrs = r.getFailedArtifactsReports();
            for (int i = 0; i < adrs.length; ++i) {
                ret.add("download failed: " + adrs[i].getArtifact());
            }
        }
        return ret;
    }

    public void setDependencies(List dependencies, Filter artifactFilter) {
        this.dependencies = dependencies;
        this.artifacts = new ArrayList();
        for (IvyNode dependency : dependencies) {
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            String[] dconfs = dependency.getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconfs[j]);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public List getModuleIds() {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        ArrayList sortedDependencies = new ArrayList(this.dependencies);
        for (IvyNode dependency : sortedDependencies) {
            ModuleId mid = dependency.getResolvedId().getModuleId();
            if (ret.contains(mid)) continue;
            ret.add(mid);
        }
        return ret;
    }

    public void setResolveTime(long elapsedTime) {
        this.resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this.downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long size) {
        this.downloadSize = size;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    private String[] getExtendingConfs(String extended) {
        String[] allConfs = this.md.getConfigurationsNames();
        HashSet<String> extendingConfs = new HashSet<String>();
        extendingConfs.add(extended);
        for (int i = 0; i < allConfs.length; ++i) {
            this.gatherExtendingConfs(extendingConfs, allConfs[i], extended);
        }
        return extendingConfs.toArray(new String[extendingConfs.size()]);
    }

    private boolean gatherExtendingConfs(Set<String> extendingConfs, String conf, String extended) {
        if (extendingConfs.contains(conf)) {
            return true;
        }
        String[] ext = this.md.getConfiguration(conf).getExtends();
        if (ext == null || ext.length == 0) {
            return false;
        }
        for (int i = 0; i < ext.length; ++i) {
            if (extendingConfs.contains(ext[i])) {
                extendingConfs.add(conf);
                return true;
            }
            if (ext[i].equals(extended)) {
                extendingConfs.add(conf);
                return true;
            }
            if (!this.gatherExtendingConfs(extendingConfs, ext[i], extended)) continue;
            extendingConfs.add(conf);
            return true;
        }
        return false;
    }

    public ModuleDescriptor toFixedModuleDescriptor(IvySettings settings, List<ModuleId> midToKeep) {
        DefaultModuleDescriptor fixedmd = new DefaultModuleDescriptor(this.md.getModuleRevisionId(), this.md.getStatus(), new Date());
        fixedmd.getExtraInfos().addAll(this.md.getExtraInfos());
        List<String> resolvedConfs = Arrays.asList(this.getConfigurations());
        for (String conf : resolvedConfs) {
            fixedmd.addConfiguration(new Configuration(conf));
        }
        if (midToKeep != null && !midToKeep.isEmpty()) {
            DependencyDescriptor[] deps = this.md.getDependencies();
            for (int i = 0; i < deps.length; ++i) {
                if (!midToKeep.contains(deps[i].getDependencyId())) continue;
                DefaultDependencyDescriptor dep = new DefaultDependencyDescriptor(fixedmd, deps[i].getDependencyRevisionId(), true, false, false);
                List<String> confs = Arrays.asList(deps[i].getModuleConfigurations());
                if (confs.size() == 1 && confs.get(0).equals("*")) {
                    confs = resolvedConfs;
                }
                for (String conf : confs) {
                    String[] extendedConfs = this.getExtendingConfs(conf);
                    String[] depConfs = deps[i].getDependencyConfigurations(conf);
                    for (String extendedConf : extendedConfs) {
                        if (!resolvedConfs.contains(extendedConf)) continue;
                        for (String depConf : depConfs) {
                            dep.addDependencyConfiguration(extendedConf, depConf);
                        }
                    }
                }
                fixedmd.addDependency(dep);
            }
        }
        block5: for (int i = 0; i < this.dependencies.size(); ++i) {
            IvyNode node = (IvyNode)this.dependencies.get(i);
            if (midToKeep != null && midToKeep.contains(node.getModuleId())) continue;
            String[] rootConfs = node.getRootModuleConfigurations();
            for (int j = 0; j < rootConfs.length; ++j) {
                if (node.isEvicted(rootConfs[j])) continue;
                if (node.getAllArtifacts().length == 0) continue block5;
                DefaultDependencyDescriptor dep = new DefaultDependencyDescriptor(fixedmd, node.getResolvedId(), true, false, false);
                String[] targetConfs = node.getConfigurations(rootConfs[j]);
                for (int k = 0; k < targetConfs.length; ++k) {
                    dep.addDependencyConfiguration(rootConfs[j], targetConfs[k]);
                }
                fixedmd.addDependency(dep);
            }
        }
        return fixedmd;
    }
}

