/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.repo;

import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.ManifestAndLocation;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactReportManifestIterable
implements Iterable<ManifestAndLocation> {
    private final Map<ModuleRevisionId, List<ArtifactDownloadReport>> artifactReports = new HashMap<ModuleRevisionId, List<ArtifactDownloadReport>>();
    private List<String> sourceTypes;

    public ArtifactReportManifestIterable(List<ArtifactDownloadReport> reports, List<String> sourceTypes) {
        this.sourceTypes = sourceTypes;
        for (ArtifactDownloadReport report : reports) {
            ModuleRevisionId mrid = report.getArtifact().getModuleRevisionId();
            List<ArtifactDownloadReport> moduleReports = this.artifactReports.get(mrid);
            if (moduleReports == null) {
                moduleReports = new ArrayList<ArtifactDownloadReport>();
                this.artifactReports.put(mrid, moduleReports);
            }
            moduleReports.add(report);
        }
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new ArtifactReportManifestIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArtifactReportManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Iterator<ModuleRevisionId> it;

        public ArtifactReportManifestIterator() {
            this.it = ArtifactReportManifestIterable.this.artifactReports.keySet().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null && this.it.hasNext()) {
                ModuleRevisionId mrid = this.it.next();
                List reports = (List)ArtifactReportManifestIterable.this.artifactReports.get(mrid);
                ArtifactDownloadReport jar = null;
                ArtifactDownloadReport source = null;
                for (ArtifactDownloadReport report : reports) {
                    if (ArtifactReportManifestIterable.this.sourceTypes != null && ArtifactReportManifestIterable.this.sourceTypes.contains(report.getArtifact().getType())) {
                        source = report;
                        continue;
                    }
                    jar = report;
                }
                if (jar == null) continue;
                URI sourceURI = null;
                if (source != null) {
                    sourceURI = source.getUnpackedLocalFile() != null ? source.getUnpackedLocalFile().toURI() : source.getLocalFile().toURI();
                }
                if (jar.getUnpackedLocalFile() != null && jar.getUnpackedLocalFile().isDirectory()) {
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(new File(jar.getUnpackedLocalFile(), "META-INF/MANIFEST.MF"));
                        this.next = new ManifestAndLocation(new Manifest(in), jar.getUnpackedLocalFile().toURI(), sourceURI);
                        boolean bl = true;
                        return bl;
                    }
                    catch (FileNotFoundException e) {
                        Message.debug("Bundle directory file just removed: " + jar.getUnpackedLocalFile(), e);
                        continue;
                    }
                    catch (IOException e) {
                        Message.debug("The Manifest in the bundle directory could not be read: " + jar.getUnpackedLocalFile(), e);
                        continue;
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                        continue;
                    }
                }
                File artifact = jar.getUnpackedLocalFile() != null ? jar.getUnpackedLocalFile() : jar.getLocalFile();
                ZipInputStream in = null;
                try {
                    in = new JarInputStream(new FileInputStream(artifact));
                    Manifest manifest = ((JarInputStream)in).getManifest();
                    if (manifest != null) {
                        this.next = new ManifestAndLocation(manifest, artifact.toURI(), sourceURI);
                        boolean bl = true;
                        return bl;
                    }
                    Message.debug("No manifest in jar: " + artifact);
                }
                catch (FileNotFoundException e) {
                    Message.debug("Jar file just removed: " + artifact, e);
                }
                catch (IOException e) {
                    Message.warn("Unreadable jar: " + artifact, e);
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            return this.next != null;
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifest = this.next;
            this.next = null;
            return manifest;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

