/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.repo;

import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleArtifact;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfo;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ManifestParser;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.ManifestAndLocation;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRepoDescriptor
extends EditableRepoDescriptor {
    private String name;
    private String lastModified;

    public BundleRepoDescriptor(URI baseUri, ExecutionEnvironmentProfileProvider profileProvider) {
        super(baseUri, profileProvider);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void populate(Iterator<ManifestAndLocation> it) {
        while (it.hasNext()) {
            ManifestAndLocation manifestAndLocation = it.next();
            try {
                BundleInfo bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.addArtifact(new BundleArtifact(false, manifestAndLocation.getUri(), null));
                this.addBundle(bundleInfo);
            }
            catch (ParseException e) {
                Message.error("Rejected " + manifestAndLocation.getUri() + ": " + e.getMessage());
            }
        }
    }
}

