/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.conflict;

import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.plugins.conflict.AbstractConflictManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class FixedConflictManager
extends AbstractConflictManager {
    private Collection revisions;

    public FixedConflictManager(String[] revs) {
        this.revisions = Arrays.asList(revs);
        this.setName("fixed" + this.revisions);
    }

    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        ArrayList<IvyNode> resolved = new ArrayList<IvyNode>(conflicts.size());
        for (IvyNode node : conflicts) {
            String revision = node.getResolvedId().getRevision();
            if (!this.revisions.contains(revision)) continue;
            resolved.add(node);
        }
        return resolved;
    }

    public Collection getRevs() {
        return this.revisions;
    }
}

