/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.SDKManagerListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ThreadedSDKManager
implements SDKManager {
    private final ScheduledExecutorService _sdkExecutor = Executors.newSingleThreadScheduledExecutor();
    private final SDKManager _manager;

    public ThreadedSDKManager(SDKManager manager) {
        this._manager = manager;
    }

    @Override
    public boolean copyCachedSDK(final String apiKey, final PersistedSDK currentSDK) throws IOException {
        try {
            return this._sdkExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ThreadedSDKManager.this._manager.copyCachedSDK(apiKey, currentSDK);
                }
            }).get();
        }
        catch (InterruptedException e) {
            DeveloperTools.logD("Crashlytics was interrupted during its update of the SDK for api key " + apiKey);
        }
        catch (ExecutionException e) {
            DeveloperTools.logE("Crashlytics execution failed during its update of the SDK for api key " + apiKey, e);
        }
        return false;
    }

    @Override
    public boolean updateCachedSDK(final WebApi api, final String apiKey) throws IOException {
        try {
            return this._sdkExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ThreadedSDKManager.this._manager.updateCachedSDK(api, apiKey);
                }
            }).get();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted during its update of the SDK for api key " + apiKey, e);
        }
        catch (ExecutionException e) {
            DeveloperTools.logE("Crashlytics execution failed during its update of the SDK for api key " + apiKey, e);
        }
        return false;
    }

    @Override
    public void dispose() {
        DeveloperTools.logD("Crashlytics is shutting down the SDK...");
        this._sdkExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ThreadedSDKManager.this._manager.dispose();
            }
        });
        this._sdkExecutor.shutdown();
    }

    @Override
    public void addSDKManagerListener(final SDKManagerListener listener) {
        try {
            this._sdkExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ThreadedSDKManager.this._manager.addSDKManagerListener(listener);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted during adding a listener to the SDK manager", e);
        }
        catch (ExecutionException e) {
            DeveloperTools.logE("Crashlytics execution failed during adding a listener to the SDK manager", e);
        }
    }

    @Override
    public void removeSDKManagerListener(final SDKManagerListener listener) {
        try {
            this._sdkExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ThreadedSDKManager.this._manager.removeSDKManagerListener(listener);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted during removal a listener to of the SDK manager", e);
        }
        catch (ExecutionException e) {
            DeveloperTools.logE("Crashlytics execution failed during removal a listener to of the SDK manager", e);
        }
    }

    @Override
    public boolean isSdkAvailable(final String apiKey) {
        try {
            return this._sdkExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ThreadedSDKManager.this._manager.isSdkAvailable(apiKey);
                }
            }).get();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted during adding a listener to the SDK manager", e);
        }
        catch (ExecutionException e) {
            DeveloperTools.logE("Crashlytics execution failed during adding a listener to the SDK manager", e);
        }
        return false;
    }
}

