/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Collections;

public class TwitterSyndicationCodeBlockFactory {
    public static String getViewXML(String indent) {
        Joiner joiner = Joiner.on(indent);
        return joiner.join("\n    <com.twitter.sdk.android.tweetui.TweetView", "xmlns:twittersdk=\"http://schemas.android.com/apk/res-auto\"", "android:id=\"@+id/photo_default_tweet\"", "android:layout_width=\"match_parent\"", "android:layout_height=\"wrap_content\"", "twittersdk:tw__tweet_id=\"20\"/>");
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length() + 1, toAdd);
    }

    public static CodeChange getManualLayoutDirections(String viewFileContents) {
        String layoutElementcontent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterSyndicationCodeBlockFactory.injectAfter(layoutElementcontent, viewFileContents, TwitterSyndicationCodeBlockFactory.getViewXML("\n        "))));
    }
}

