/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.reloc.org.apache.commons.codec.digest.DigestUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.codemapping.csym.CSymIdStrategy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AndroidCSymIdStrategy
implements CSymIdStrategy {
    private final File _ndkLibsOutDir;

    public AndroidCSymIdStrategy(File ndkLibsOutDir) {
        this._ndkLibsOutDir = ndkLibsOutDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createCSymIdForFile(File objFile) throws IOException {
        if (!this._ndkLibsOutDir.isDirectory()) {
            throw new DeveloperTools.PluginException("Could not find NDK libs output path: " + this._ndkLibsOutDir);
        }
        String arch = objFile.getParentFile().getName();
        File libDir = new File(this._ndkLibsOutDir, arch);
        File libFile = new File(libDir, objFile.getName());
        if (!libFile.exists() || !libFile.isFile()) {
            throw new DeveloperTools.PluginException("Could not find matching lib file: " + libFile);
        }
        InputStream in = null;
        String shaHex = null;
        try {
            in = new BufferedInputStream(new FileInputStream(libFile));
            shaHex = DigestUtils.shaHex(in);
        }
        finally {
            in.close();
        }
        return shaHex;
    }
}

