/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.reloc.org.apache.commons.io.FileUtils;
import com.crashlytics.reloc.org.apache.commons.io.IOCase;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.FileFilterUtils;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.IOFileFilter;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.TrueFileFilter;
import com.crashlytics.tools.android.project.codemapping.csym.CSym;
import com.crashlytics.tools.android.project.codemapping.csym.CSymFileWriter;
import com.crashlytics.tools.android.project.codemapping.csym.CSymWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class GZipCSymFileWriter
implements CSymFileWriter {
    public static final String CSYM_SUFFIX = ".cSYM.gz";
    private static final IOFileFilter CSYM_FILE_FILTER = FileFilterUtils.suffixFileFilter(".cSYM.gz", IOCase.INSENSITIVE);
    private final File _outputDir;

    public GZipCSymFileWriter(File outputDir) {
        this._outputDir = outputDir;
    }

    @Override
    public File writeCSymFile(CSym cSym, String filename) throws IOException {
        com.crashlytics.tools.utils.FileUtils.verifyDirectory(this._outputDir);
        File cSymFile = new File(this._outputDir, filename);
        this.writeCSymToGzipFile(cSym, cSymFile);
        return cSymFile;
    }

    @Override
    public List<File> getCSymFiles() {
        if (!this._outputDir.isDirectory()) {
            return Collections.emptyList();
        }
        return new LinkedList<File>(FileUtils.listFiles(this._outputDir, CSYM_FILE_FILTER, TrueFileFilter.INSTANCE));
    }

    @Override
    public String getOutputFilename(CSym cSym, String moduleName) {
        return String.format("%s-%s-%s", moduleName, cSym.getArchitecture(), cSym.getUUID()) + CSYM_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCSymToGzipFile(CSym cSym, File file) throws IOException {
        OutputStream os = null;
        try {
            os = new GZIPOutputStream(new FileOutputStream(file));
            CSymWriter.writeToOutputStream(cSym, os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

