/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.utils.ParseStringStrategy;
import java.io.UnsupportedEncodingException;

public class Utf16ParseStringStrategy
implements ParseStringStrategy {
    @Override
    public String parseStringFrom(byte[] buf) throws UnsupportedEncodingException {
        if (buf.length % 2 != 0) {
            return null;
        }
        int nullTerminatorLength = 0;
        int littleByteIndex = buf.length - 2;
        int bigByteIndex = buf.length - 1;
        while (nullTerminatorLength < buf.length && buf[littleByteIndex] == 0 && buf[bigByteIndex] == 0) {
            nullTerminatorLength += 2;
            littleByteIndex -= 2;
            bigByteIndex -= 2;
        }
        if (nullTerminatorLength > 0) {
            byte[] subString = new byte[buf.length - nullTerminatorLength];
            System.arraycopy(buf, 0, subString, 0, buf.length - nullTerminatorLength);
            buf = subString;
        }
        return new String(buf, "UTF-16LE");
    }
}

