/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.EnrollmentsJsonTransform;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import java.util.Collections;
import java.util.Map;

public class Organization {
    public static final String ENROLLMENT_BETA_DISTRIBUTION = "beta_distribution";
    private final String _id;
    private final String _alias;
    private final String _name;
    private final String _apiKey;
    private final int _appCount;
    private final String _buildSecret;
    private final Map<String, Object> _enrollments;
    private final boolean _sdkEnabled;

    public Organization(String id, String alias, String name, String apiKey, int appCount, String buildSecret, Map<String, Object> enrollments, boolean sdkEnabled) {
        if (alias.isEmpty() || name.isEmpty() || apiKey.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty parameter: " + alias + ", " + name + ", " + apiKey);
        }
        this._id = id;
        this._alias = alias;
        this._name = name;
        this._apiKey = apiKey;
        this._appCount = appCount;
        this._buildSecret = buildSecret;
        this._enrollments = enrollments;
        this._sdkEnabled = sdkEnabled;
    }

    public Organization(JSONObject json) {
        this((String)json.get("id"), (String)json.get("alias"), (String)json.get("name"), (String)json.get("api_key"), Organization.calculateOrgAppCounts((JSONObject)json.get("apps_counts")), (String)json.get("build_secret"), new EnrollmentsJsonTransform().createEnrollmentsFrom((JSONObject)json.get("enrollments")), Optional.fromNullable((Boolean)json.get("sdk_organization")).or(false));
    }

    private static int calculateOrgAppCounts(JSONObject appCountsJson) {
        int count = 0;
        for (Object obj : appCountsJson.values()) {
            count += ((Number)obj).intValue();
        }
        return count;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getName() {
        return this._name;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public int getAppCount() {
        return this._appCount;
    }

    public String getId() {
        return this._id;
    }

    public String getBuildSecret() {
        return this._buildSecret;
    }

    public boolean enrollmentsEqual(Map<String, Object> enrollments) {
        if (this._enrollments == null) {
            return enrollments == null;
        }
        return ((Object)this._enrollments).equals(enrollments);
    }

    public Map<String, Object> getEnrollments() {
        return this._enrollments == null ? null : Collections.unmodifiableMap(this._enrollments);
    }

    public boolean isBetaDistibutionEnabled() {
        Object enrollmentValue = this._enrollments.get(ENROLLMENT_BETA_DISTRIBUTION);
        return enrollmentValue == null ? false : Boolean.parseBoolean(enrollmentValue.toString());
    }

    public boolean isSdkOrganization() {
        return this._sdkEnabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._alias == null ? 0 : this._alias.hashCode());
        result = 31 * result + (this._apiKey == null ? 0 : this._apiKey.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Organization other = (Organization)obj;
        return this._alias.equals(other._alias) && this._apiKey.equals(other._apiKey) && this._name.equals(other._name);
    }

    public String toString() {
        return this._name;
    }
}

