/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.AppVersion;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.tools.android.DeveloperTools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppVersionJsonTransform {
    static final String MAJOR = "major";
    static final String MINOR = "minor";
    static final String CREATED_AT = "created_at";
    static final String DISTRIBUTION_COUNT = "distribution_count";

    public AppVersion transform(JSONObject jsonAppVersion) {
        Date timestamp;
        String displayVersion = (String)jsonAppVersion.get(MAJOR);
        int buildVersion = 0;
        try {
            buildVersion = Integer.parseInt((String)jsonAppVersion.get(MINOR));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String timestampString = (String)jsonAppVersion.get(CREATED_AT);
        SimpleDateFormat jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            timestamp = jsonDateFormat.parse(timestampString);
        }
        catch (ParseException e) {
            DeveloperTools.logE("Could not parse date string: " + jsonDateFormat, e);
            timestamp = new Date();
        }
        long distributionCount = (Long)jsonAppVersion.get(DISTRIBUTION_COUNT);
        return new AppVersion(displayVersion, buildVersion, timestamp, distributionCount);
    }
}

