/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.DistributionSelectableItem;

public class PersonGroup
implements DistributionSelectableItem {
    private static final String ENABLED = "enabled";
    private static final int UNINITIALIZED_COUNT = -1;
    public final String id;
    public final String name;
    public final String access;
    public final int testerCount;
    public final int releaseTesterCount;
    private boolean _selected = false;

    public PersonGroup(String id, String name) {
        this(id, name, null, -1, -1);
    }

    public PersonGroup(String id, String name, String access, int testerCount, int releaseTesterCount) {
        if (id == null) {
            throw new NullPointerException("id must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.id = id;
        this.name = name;
        this.access = access;
        this.testerCount = testerCount;
        this.releaseTesterCount = releaseTesterCount;
        this._selected = this.isAccessEnabled();
    }

    public int getNewTesterCount() {
        return this.testerCount - this.releaseTesterCount;
    }

    public boolean isAccessEnabled() {
        return ENABLED.equals(this.access);
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    @Override
    public boolean isTester() {
        return false;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersonGroup)) {
            return false;
        }
        PersonGroup other = (PersonGroup)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", selected=" + this._selected + '}';
    }

    String getNameForComparison() {
        return this.name == null ? "" : this.name.toLowerCase();
    }
}

