/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.UriParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String name) {
        StringBuffer b = new StringBuffer(name);
        try {
            UriParser.fixSeparators(b);
            this.extractRootPrefix(name, b);
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuffer var2) throws FileSystemException;

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(filename, name);
        if (scheme == null) {
            scheme = "file";
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        String rootFile = this.extractRootPrefix(filename, name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return this.createFileName(scheme, rootFile, path, fileType);
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

