/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.res;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.UriParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URL url;
        StringBuffer buf = new StringBuffer(80);
        UriParser.extractScheme(uri, buf);
        String resourceName = buf.toString();
        ClassLoader cl = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((url = cl.getResource(resourceName)) == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri);
        }
        FileObject fo = this.getContext().getFileSystemManager().resolveFile(url.toExternalForm());
        return fo;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public void closeFileSystem(FileSystem filesystem) {
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

