/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp;

import com.crashlytics.dependency.reloc.com.jcraft.jsch.Session;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.UserAuthenticationData;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp.SftpClientFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp.SftpFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.UserAuthenticatorUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.RANDOM_ACCESS_READ));
    public static final String ATTR_USER_INFO = "UI";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public SftpFileProvider() {
        this.setFileNameParser(SftpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), fileSystemOptions);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", name, (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup(authData);
        }
        return new SftpFileSystem(rootName, session, fileSystemOptions);
    }

    public void init() throws FileSystemException {
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return SftpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

