/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Selectors;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks.CopyTask;

public class MoveTask
extends CopyTask {
    private boolean tryRename = false;

    public void setTryRename(boolean tryRename) {
        this.tryRename = tryRename;
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        if (!this.tryRename || !srcFile.canRenameTo(destFile)) {
            super.handleOutOfDateFile(srcFile, destFile);
            this.log("Deleting " + srcFile);
            srcFile.delete(Selectors.SELECT_SELF);
        } else {
            this.log("Rename " + srcFile + " to " + destFile);
            srcFile.moveTo(destFile);
            if (!this.isPreserveLastModified() && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
                destFile.getContent().setLastModifiedTime(System.currentTimeMillis());
            }
        }
    }
}

