/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib;

import com.crashlytics.reloc.com.android.io.FileWrapper;
import com.crashlytics.reloc.com.android.prefs.AndroidLocation;
import com.crashlytics.reloc.com.android.sdklib.AddOnTarget;
import com.crashlytics.reloc.com.android.sdklib.AndroidVersion;
import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.ISdkLog;
import com.crashlytics.reloc.com.android.sdklib.ISystemImage;
import com.crashlytics.reloc.com.android.sdklib.NullSdkLog;
import com.crashlytics.reloc.com.android.sdklib.PlatformTarget;
import com.crashlytics.reloc.com.android.sdklib.SdkConstants;
import com.crashlytics.reloc.com.android.sdklib.SystemImage;
import com.crashlytics.reloc.com.android.sdklib.internal.project.ProjectProperties;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ExtraPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.LocalSdkParser;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.NullTaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdkManager {
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    public static final String ADDON_NAME = "name";
    public static final String ADDON_VENDOR = "vendor";
    public static final String ADDON_API = "api";
    public static final String ADDON_DESCRIPTION = "description";
    public static final String ADDON_LIBRARIES = "libraries";
    public static final String ADDON_DEFAULT_SKIN = "skin";
    public static final String ADDON_USB_VENDOR = "usb-vendor";
    public static final String ADDON_REVISION = "revision";
    public static final String ADDON_REVISION_OLD = "version";
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final Pattern PATTERN_USB_IDS = Pattern.compile("^0x[a-f0-9]{4}$", 2);
    private static final String[] sPlatformContentList = new String[]{"android.jar", "framework.aidl"};
    private static final String ADB_INI_FILE = "adb_usb.ini";
    private static final String ADB_INI_HEADER = "# ANDROID 3RD PARTY USB VENDOR ID LIST -- DO NOT EDIT.\n# USE 'android update adb' TO GENERATE.\n# 1 USB VENDOR ID PER LINE.\n";
    private final String mOsSdkPath;
    private IAndroidTarget[] mTargets = new IAndroidTarget[0];

    protected SdkManager(String string) {
        this.mOsSdkPath = string;
    }

    public static SdkManager createManager(String string, ISdkLog iSdkLog) {
        try {
            SdkManager sdkManager = new SdkManager(string);
            ArrayList<IAndroidTarget> arrayList = new ArrayList<IAndroidTarget>();
            SdkManager.loadPlatforms(string, arrayList, iSdkLog);
            SdkManager.loadAddOns(string, arrayList, iSdkLog);
            Collections.sort(arrayList);
            sdkManager.setTargets(arrayList.toArray(new IAndroidTarget[arrayList.size()]));
            sdkManager.initializeSamplePaths(iSdkLog);
            return sdkManager;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iSdkLog.error(illegalArgumentException, "Error parsing the sdk.", new Object[0]);
            return null;
        }
    }

    public String getLocation() {
        return this.mOsSdkPath;
    }

    public IAndroidTarget[] getTargets() {
        return this.mTargets;
    }

    protected void setTargets(IAndroidTarget[] iAndroidTargetArray) {
        assert (iAndroidTargetArray != null);
        this.mTargets = iAndroidTargetArray;
    }

    public IAndroidTarget getTargetFromHashString(String string) {
        if (string != null) {
            for (IAndroidTarget iAndroidTarget : this.mTargets) {
                if (!string.equals(iAndroidTarget.hashString())) continue;
                return iAndroidTarget;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdb() throws AndroidLocation.AndroidLocationException, IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = new File(AndroidLocation.getFolder(), ADB_INI_FILE);
            outputStreamWriter = new FileWriter(file);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            IAndroidTarget[] iAndroidTargetArray = this.getTargets();
            for (IAndroidTarget iAndroidTarget : iAndroidTargetArray) {
                if (iAndroidTarget.getUsbVendorId() == 0) continue;
                hashSet.add(iAndroidTarget.getUsbVendorId());
            }
            outputStreamWriter.write(ADB_INI_HEADER);
            for (Integer n : hashSet) {
                outputStreamWriter.write(String.format("0x%04x\n", n));
            }
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
    }

    public void reloadSdk(ISdkLog iSdkLog) {
        ArrayList<IAndroidTarget> arrayList = new ArrayList<IAndroidTarget>();
        SdkManager.loadPlatforms(this.mOsSdkPath, arrayList, iSdkLog);
        SdkManager.loadAddOns(this.mOsSdkPath, arrayList, iSdkLog);
        Collections.sort(arrayList);
        this.setTargets(arrayList.toArray(new IAndroidTarget[arrayList.size()]));
        this.initializeSamplePaths(iSdkLog);
    }

    @Deprecated
    public LayoutlibVersion getMaxLayoutlibVersion() {
        LayoutlibVersion layoutlibVersion = null;
        for (IAndroidTarget iAndroidTarget : this.getTargets()) {
            LayoutlibVersion layoutlibVersion2;
            if (!(iAndroidTarget instanceof PlatformTarget) || (layoutlibVersion2 = ((PlatformTarget)iAndroidTarget).getLayoutlibVersion()) == null || layoutlibVersion != null && layoutlibVersion2.compareTo(layoutlibVersion) <= 0) continue;
            layoutlibVersion = layoutlibVersion2;
        }
        return layoutlibVersion;
    }

    public Map<File, String> getExtraSamples() {
        LocalSdkParser localSdkParser = new LocalSdkParser();
        Package[] packageArray = localSdkParser.parseSdk(this.mOsSdkPath, this, 1024, new NullTaskMonitor(new NullSdkLog()));
        HashMap<File, String> hashMap = new HashMap<File, String>();
        for (Package package_ : packageArray) {
            if (!(package_ instanceof ExtraPackage) || !package_.isLocal()) continue;
            assert (package_.getArchives() != null && package_.getArchives().length == 1);
            Archive archive = package_.getArchives()[0];
            assert (archive != null);
            File file = new File(archive.getLocalOsPath(), "samples");
            if (!file.isDirectory()) continue;
            hashMap.put(file, package_.getListDescription());
        }
        return hashMap;
    }

    private static void loadPlatforms(String string, ArrayList<IAndroidTarget> arrayList, ISdkLog iSdkLog) {
        File file = new File(string, "platforms");
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    PlatformTarget platformTarget = SdkManager.loadPlatform(string, file2, iSdkLog);
                    if (platformTarget == null) continue;
                    arrayList.add(platformTarget);
                    continue;
                }
                iSdkLog.warning("Ignoring platform '%1$s', not a folder.", file2.getName());
            }
            return;
        }
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new RuntimeException(String.format("Failed to create %1$s.", file.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(String.format("%1$s is not a folder.", file.getAbsolutePath()));
        }
    }

    private static PlatformTarget loadPlatform(String string, File file, ISdkLog iSdkLog) {
        FileWrapper fileWrapper = new FileWrapper(file, "build.prop");
        FileWrapper fileWrapper2 = new FileWrapper(file, "source.properties");
        if (fileWrapper.isFile() && fileWrapper2.isFile()) {
            Object object;
            ISystemImage[] iSystemImageArray;
            String string2;
            int n;
            String string3;
            FileWrapper fileWrapper3;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Map<String, String> map = ProjectProperties.parsePropertyFile(fileWrapper, iSdkLog);
            if (map != null) {
                hashMap.putAll(map);
            }
            if ((map = ProjectProperties.parsePropertyFile(fileWrapper2, iSdkLog)) != null) {
                hashMap.putAll(map);
            }
            if ((fileWrapper3 = new FileWrapper(file, "sdk.properties")).isFile() && (map = ProjectProperties.parsePropertyFile(fileWrapper3, iSdkLog)) != null) {
                hashMap.putAll(map);
            }
            if ((string3 = (String)hashMap.get(PROP_VERSION_SDK)) == null) {
                iSdkLog.warning("Ignoring platform '%1$s': %2$s is missing from '%3$s'", file.getName(), PROP_VERSION_SDK, "build.prop");
                return null;
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                iSdkLog.warning("Ignoring platform '%1$s': %2$s is not a valid number in %3$s.", file.getName(), PROP_VERSION_SDK, "build.prop");
                return null;
            }
            String string4 = (String)hashMap.get(PROP_VERSION_CODENAME);
            if (string4 != null && string4.equals("REL")) {
                string4 = null;
            }
            if ((string2 = (String)hashMap.get("Platform.Version")) == null) {
                string2 = (String)hashMap.get(PROP_VERSION_RELEASE);
            }
            if (string2 == null) {
                iSdkLog.warning("Ignoring platform '%1$s': %2$s is missing from '%3$s'", file.getName(), PROP_VERSION_RELEASE, "build.prop");
                return null;
            }
            int n2 = 1;
            LayoutlibVersion layoutlibVersion = null;
            try {
                n2 = Integer.parseInt((String)hashMap.get("Pkg.Revision"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int n3;
                iSystemImageArray = (ISystemImage[])hashMap.get("Layoutlib.Api");
                object = (String)hashMap.get("Layoutlib.Revision");
                int n4 = iSystemImageArray == null ? 0 : Integer.parseInt((String)iSystemImageArray);
                int n5 = n3 = object == null ? 0 : Integer.parseInt((String)object);
                if (n4 > 0 && n3 >= 0) {
                    layoutlibVersion = new LayoutlibVersion(n4, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!SdkManager.checkPlatformContent(file, iSdkLog)) {
                return null;
            }
            iSystemImageArray = SdkManager.getPlatformSystemImages(string, file, n, string4);
            object = new PlatformTarget(string, file.getAbsolutePath(), n, string4, string2, n2, layoutlibVersion, iSystemImageArray, hashMap);
            String[] stringArray = SdkManager.parseSkinFolder(((PlatformTarget)object).getPath(5));
            ((PlatformTarget)object).setSkins(stringArray);
            return object;
        }
        iSdkLog.warning("Ignoring platform '%1$s': %2$s is missing.", file.getName(), "build.prop");
        return null;
    }

    private static ISystemImage[] getAddonSystemImages(File file) {
        TreeSet<SystemImage> treeSet = new TreeSet<SystemImage>();
        file = new File(file, SdkConstants.OS_IMAGES_FOLDER);
        File[] fileArray = file.listFiles();
        boolean bl = false;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    treeSet.add(new SystemImage(file2, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, file2.getName()));
                    continue;
                }
                if (bl || !file2.isFile() || !file2.getName().endsWith(".img")) continue;
                bl = true;
            }
        }
        if (treeSet.size() == 0 && bl && file.isDirectory()) {
            treeSet.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return treeSet.toArray(new ISystemImage[treeSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISystemImage[] getPlatformSystemImages(String string, File file, int n, String string2) {
        TreeSet<SystemImage> treeSet = new TreeSet<SystemImage>();
        HashSet<String> hashSet = new HashSet<String>();
        AndroidVersion androidVersion = new AndroidVersion(n, string2);
        File[] fileArray = new File(string, "system-images").listFiles();
        if (fileArray != null) {
            for (File fileArray2 : fileArray) {
                File[] fileArray3 = fileArray2.listFiles();
                if (fileArray3 == null) continue;
                for (File file2 : fileArray3) {
                    try {
                        String string3;
                        File exception = new File(file2, "source.properties");
                        Properties properties = new Properties();
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(exception);
                            properties.load(fileInputStream);
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        AndroidVersion androidVersion2 = new AndroidVersion(properties);
                        if (!androidVersion2.equals(androidVersion) || (string3 = properties.getProperty("SystemImage.Abi")) == null || hashSet.contains(string3)) continue;
                        treeSet.add(new SystemImage(file2, ISystemImage.LocationType.IN_SYSTEM_IMAGE, string3));
                        hashSet.add(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        file = new File(file, SdkConstants.OS_IMAGES_FOLDER);
        File[] fileArray4 = file.listFiles();
        int n2 = 1;
        int n3 = 0;
        if (fileArray4 != null) {
            for (File file3 : fileArray4) {
                if (file3.isDirectory()) {
                    n2 = 0;
                    String string4 = file3.getName();
                    if (hashSet.contains(string4)) continue;
                    treeSet.add(new SystemImage(file3, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, string4));
                    hashSet.add(string4);
                    continue;
                }
                if (n3 != 0 || !file3.isFile() || !file3.getName().endsWith(".img")) continue;
                n3 = 1;
            }
        }
        if (n2 != 0 && n3 != 0 && file.isDirectory() && !hashSet.contains("armeabi")) {
            treeSet.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return treeSet.toArray(new ISystemImage[treeSet.size()]);
    }

    private static void loadAddOns(String string, ArrayList<IAndroidTarget> arrayList, ISdkLog iSdkLog) {
        File file = new File(string, "add-ons");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            IAndroidTarget[] iAndroidTargetArray = arrayList.toArray(new IAndroidTarget[arrayList.size()]);
            for (File file2 : fileArray) {
                AddOnTarget addOnTarget;
                if (!file2.isDirectory() || (addOnTarget = SdkManager.loadAddon(file2, iAndroidTargetArray, iSdkLog)) == null) continue;
                arrayList.add(addOnTarget);
            }
            return;
        }
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new RuntimeException(String.format("Failed to create %1$s.", file.getAbsolutePath()));
            }
        } else {
            throw new RuntimeException(String.format("%1$s is not a folder.", file.getAbsolutePath()));
        }
    }

    private static AddOnTarget loadAddon(File file, IAndroidTarget[] iAndroidTargetArray, ISdkLog iSdkLog) {
        Pair<Map<String, String>, String> pair = SdkManager.parseAddonProperties(file, iAndroidTargetArray, iSdkLog);
        Map<String, String> map = pair.getFirst();
        String string = pair.getSecond();
        if (string != null) {
            iSdkLog.warning("Ignoring add-on '%1$s': %2$s", file.getName(), string);
            return null;
        }
        try {
            int n;
            Object object;
            Object object2;
            Object object32;
            Object[] objectArray;
            String string2;
            assert (map != null);
            String string22 = map.get(ADDON_API);
            String string3 = map.get(ADDON_NAME);
            String string4 = map.get(ADDON_VENDOR);
            assert (string22 != null);
            assert (string3 != null);
            assert (string4 != null);
            PlatformTarget platformTarget = null;
            for (IAndroidTarget iAndroidTarget : iAndroidTargetArray) {
                if (!iAndroidTarget.isPlatform() || !iAndroidTarget.getVersion().equals(string22)) continue;
                platformTarget = (PlatformTarget)iAndroidTarget;
                break;
            }
            assert (platformTarget != null);
            String string5 = map.get(ADDON_DESCRIPTION);
            int n2 = 1;
            String string6 = map.get(ADDON_REVISION);
            if (string6 == null) {
                string6 = map.get(ADDON_REVISION_OLD);
            }
            if (string6 != null) {
                n2 = Integer.parseInt(string6);
            }
            String string7 = map.get(ADDON_LIBRARIES);
            HashMap<String, String[]> hashMap = null;
            if (string7 != null && (string2 = string7.trim()).length() > 0 && (objectArray = string2.split(";")).length > 0) {
                hashMap = new HashMap<String, String[]>();
                for (Object object32 : objectArray) {
                    object2 = map.get(object32 = ((String)object32).trim());
                    if (object2 != null) {
                        object = PATTERN_LIB_DATA.matcher((CharSequence)object2);
                        if (((Matcher)object).matches()) {
                            hashMap.put((String)object32, new String[]{((Matcher)object).group(1), ((Matcher)object).group(2)});
                            continue;
                        }
                        iSdkLog.warning("Ignoring library '%1$s', property value has wrong format\n\t%2$s", object32, object2);
                        continue;
                    }
                    iSdkLog.warning("Ignoring library '%1$s', missing property value", object32, object2);
                }
            }
            objectArray = SdkManager.getAddonSystemImages(file);
            boolean bl = false;
            int n3 = 0;
            File file2 = new File(file, "data");
            if (file2.isDirectory()) {
                bl = new File(file2, "layoutlib.jar").isFile();
                n3 = new File(file2, "res").isDirectory() && new File(file2, "fonts").isDirectory() ? 1 : 0;
            }
            object32 = new AddOnTarget(file.getAbsolutePath(), string3, string4, n2, string5, (ISystemImage[])objectArray, hashMap, bl, n3 != 0, platformTarget);
            object2 = SdkManager.parseSkinFolder(((AddOnTarget)object32).getPath(5));
            object = map.get(ADDON_DEFAULT_SKIN);
            if (object == null) {
                object = ((String[])object2).length == 1 ? object2[0] : platformTarget.getDefaultSkin();
            }
            if ((n = SdkManager.convertId(map.get(ADDON_USB_VENDOR))) != 0) {
                ((AddOnTarget)object32).setUsbVendorId(n);
            }
            ((AddOnTarget)object32).setSkins((String[])object2, (String)object);
            return object32;
        }
        catch (Exception exception) {
            iSdkLog.warning("Ignoring add-on '%1$s': error %2$s.", file.getName(), exception.toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<Map<String, String>, String> parseAddonProperties(File file, IAndroidTarget[] iAndroidTargetArray, ISdkLog iSdkLog) {
        String string;
        Map<String, String> map;
        block5: {
            void var10_13;
            block10: {
                PlatformTarget platformTarget;
                String string2;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                FileWrapper fileWrapper;
                                block4: {
                                    map = null;
                                    string = null;
                                    fileWrapper = new FileWrapper(file, "manifest.ini");
                                    if (fileWrapper.isFile()) break block4;
                                    string = String.format("File not found: %1$s", "manifest.ini");
                                    break block5;
                                }
                                map = ProjectProperties.parsePropertyFile(fileWrapper, iSdkLog);
                                if (map != null) break block6;
                                string = String.format("Failed to parse properties from %1$s", "manifest.ini");
                                break block5;
                            }
                            String string3 = map.get(ADDON_NAME);
                            if (string3 != null) break block7;
                            string = SdkManager.addonManifestWarning(ADDON_NAME);
                            break block5;
                        }
                        String string4 = map.get(ADDON_VENDOR);
                        if (string4 != null) break block8;
                        string = SdkManager.addonManifestWarning(ADDON_VENDOR);
                        break block5;
                    }
                    string2 = map.get(ADDON_API);
                    platformTarget = null;
                    if (string2 != null) break block9;
                    string = SdkManager.addonManifestWarning(ADDON_API);
                    break block5;
                }
                for (IAndroidTarget iAndroidTarget : iAndroidTargetArray) {
                    if (!iAndroidTarget.isPlatform() || !iAndroidTarget.getVersion().equals(string2)) continue;
                    platformTarget = (PlatformTarget)iAndroidTarget;
                    break;
                }
                if (platformTarget != null) break block10;
                string = String.format("Unable to find base platform with API level '%1$s'", string2);
                break block5;
            }
            String string2 = map.get(ADDON_REVISION);
            if (string2 == null) {
                String string3 = map.get(ADDON_REVISION_OLD);
            }
            if (var10_13 == null) break block5;
            try {
                Integer.parseInt((String)var10_13);
            }
            catch (NumberFormatException numberFormatException) {
                string = String.format("%1$s is not a valid number in %2$s.", ADDON_REVISION, "build.prop");
            }
        }
        return Pair.of(map, string);
    }

    private static int convertId(String string) {
        if (string != null && string.length() > 0 && PATTERN_USB_IDS.matcher(string).matches()) {
            String string2 = string.substring(2);
            try {
                return Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String addonManifestWarning(String string) {
        return String.format("'%1$s' is missing from %2$s.", string, "manifest.ini");
    }

    private static boolean checkPlatformContent(File file, ISdkLog iSdkLog) {
        for (String string : sPlatformContentList) {
            File file2 = new File(file, string);
            if (file2.exists()) continue;
            iSdkLog.warning("Ignoring platform '%1$s': %2$s is missing.", file.getName(), string);
            return false;
        }
        return true;
    }

    private static String[] parseSkinFolder(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file2 : fileArray = file.listFiles()) {
                File file3;
                if (!file2.isDirectory() || !(file3 = new File(file2, "layout")).isFile()) continue;
                arrayList.add(file2.getName());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    private void initializeSamplePaths(ISdkLog iSdkLog) {
        File file = new File(this.mOsSdkPath, "samples");
        if (file.isDirectory()) {
            File[] fileArray;
            block0: for (File file2 : fileArray = file.listFiles()) {
                AndroidVersion androidVersion;
                if (!file2.isDirectory() || (androidVersion = this.getSamplesVersion(file2, iSdkLog)) == null) continue;
                for (IAndroidTarget iAndroidTarget : this.mTargets) {
                    if (!iAndroidTarget.isPlatform() || !iAndroidTarget.getVersion().equals(androidVersion)) continue;
                    ((PlatformTarget)iAndroidTarget).setSamplesPath(file2.getAbsolutePath());
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AndroidVersion getSamplesVersion(File file, ISdkLog iSdkLog) {
        File file2 = new File(file, "source.properties");
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            return new AndroidVersion(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            iSdkLog.warning("Ignoring sample '%1$s': does not contain %2$s.", file.getName(), "source.properties");
        }
        catch (IOException iOException) {
            iSdkLog.warning("Ignoring sample '%1$s': failed reading %2$s.", file.getName(), "source.properties");
        }
        catch (AndroidVersion.AndroidVersionException androidVersionException) {
            iSdkLog.warning("Ignoring sample '%1$s': no android version found in %2$s.", file.getName(), "source.properties");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayoutlibVersion
    implements Comparable<LayoutlibVersion> {
        private final int mApi;
        private final int mRevision;
        public static final int NOT_SPECIFIED = 0;

        public LayoutlibVersion(int n, int n2) {
            this.mApi = n;
            this.mRevision = n2;
        }

        public int getApi() {
            return this.mApi;
        }

        public int getRevision() {
            return this.mRevision;
        }

        @Override
        public int compareTo(LayoutlibVersion layoutlibVersion) {
            boolean bl = this.mRevision > 0 && layoutlibVersion.mRevision > 0;
            int n = (this.mApi << 16) + (bl ? this.mRevision : 0);
            int n2 = (layoutlibVersion.mApi << 16) + (bl ? layoutlibVersion.mRevision : 0);
            return n - n2;
        }
    }
}

