/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.client.fluent;

import com.crashlytics.reloc.org.apache.http.Header;
import com.crashlytics.reloc.org.apache.http.HttpEntity;
import com.crashlytics.reloc.org.apache.http.HttpEntityEnclosingRequest;
import com.crashlytics.reloc.org.apache.http.HttpHost;
import com.crashlytics.reloc.org.apache.http.HttpVersion;
import com.crashlytics.reloc.org.apache.http.NameValuePair;
import com.crashlytics.reloc.org.apache.http.client.ClientProtocolException;
import com.crashlytics.reloc.org.apache.http.client.config.RequestConfig;
import com.crashlytics.reloc.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.crashlytics.reloc.org.apache.http.client.fluent.Executor;
import com.crashlytics.reloc.org.apache.http.client.fluent.Response;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpDelete;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpGet;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpHead;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpOptions;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpPost;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpPut;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpRequestBase;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpTrace;
import com.crashlytics.reloc.org.apache.http.entity.ByteArrayEntity;
import com.crashlytics.reloc.org.apache.http.entity.ContentType;
import com.crashlytics.reloc.org.apache.http.entity.FileEntity;
import com.crashlytics.reloc.org.apache.http.entity.InputStreamEntity;
import com.crashlytics.reloc.org.apache.http.entity.StringEntity;
import com.crashlytics.reloc.org.apache.http.protocol.HTTP;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final HttpRequestBase request;
    private final RequestConfig.Builder configBuilder;
    private SimpleDateFormat dateFormatter;

    public static Request Get(URI uri) {
        return new Request(new HttpGet(uri));
    }

    public static Request Get(String uri) {
        return new Request(new HttpGet(uri));
    }

    public static Request Head(URI uri) {
        return new Request(new HttpHead(uri));
    }

    public static Request Head(String uri) {
        return new Request(new HttpHead(uri));
    }

    public static Request Post(URI uri) {
        return new Request(new HttpPost(uri));
    }

    public static Request Post(String uri) {
        return new Request(new HttpPost(uri));
    }

    public static Request Put(URI uri) {
        return new Request(new HttpPut(uri));
    }

    public static Request Put(String uri) {
        return new Request(new HttpPut(uri));
    }

    public static Request Trace(URI uri) {
        return new Request(new HttpTrace(uri));
    }

    public static Request Trace(String uri) {
        return new Request(new HttpTrace(uri));
    }

    public static Request Delete(URI uri) {
        return new Request(new HttpDelete(uri));
    }

    public static Request Delete(String uri) {
        return new Request(new HttpDelete(uri));
    }

    public static Request Options(URI uri) {
        return new Request(new HttpOptions(uri));
    }

    public static Request Options(String uri) {
        return new Request(new HttpOptions(uri));
    }

    Request(HttpRequestBase request) {
        this.request = request;
        this.configBuilder = RequestConfig.custom();
    }

    HttpRequestBase getHttpRequest() {
        return this.request;
    }

    public Response execute() throws ClientProtocolException, IOException {
        this.request.setConfig(this.configBuilder.build());
        return new Response(Executor.CLIENT.execute(this.request));
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public Request setHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public Request setHeaders(Header ... headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public Request setCacheControl(String cacheControl) {
        this.request.setHeader("Cache-Control", cacheControl);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", this.getDateFormat().format(date));
        return this;
    }

    @Deprecated
    public Request config(String param, Object object) {
        return this;
    }

    @Deprecated
    public Request removeConfig(String param) {
        return this;
    }

    public Request version(HttpVersion version) {
        this.request.setProtocolVersion(version);
        return this;
    }

    @Deprecated
    public Request elementCharset(String charset) {
        return this;
    }

    public Request useExpectContinue() {
        this.configBuilder.setExpectContinueEnabled(true);
        return this;
    }

    public Request userAgent(String agent) {
        this.request.setHeader("User-Agent", agent);
        return this;
    }

    public Request socketTimeout(int timeout) {
        this.configBuilder.setSocketTimeout(timeout);
        return this;
    }

    public Request connectTimeout(int timeout) {
        this.configBuilder.setConnectTimeout(timeout);
        return this;
    }

    public Request staleConnectionCheck(boolean b) {
        this.configBuilder.setStaleConnectionCheckEnabled(b);
        return this;
    }

    public Request viaProxy(HttpHost proxy) {
        this.configBuilder.setProxy(proxy);
        return this;
    }

    public Request body(HttpEntity entity) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException(this.request.getMethod() + " request cannot enclose an entity");
        }
        ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams, Charset charset) {
        return this.body(new UrlEncodedFormEntity(formParams, charset));
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams) {
        return this.bodyForm(formParams, HTTP.DEF_CONTENT_CHARSET);
    }

    public Request bodyForm(NameValuePair ... formParams) {
        return this.bodyForm(Arrays.asList(formParams), HTTP.DEF_CONTENT_CHARSET);
    }

    public Request bodyString(String s, ContentType contentType) {
        return this.body(new StringEntity(s, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body(new FileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] b) {
        return this.body(new ByteArrayEntity(b));
    }

    public Request bodyByteArray(byte[] b, int off, int len) {
        return this.body(new ByteArrayEntity(b, off, len));
    }

    public Request bodyStream(InputStream instream) {
        return this.body(new InputStreamEntity(instream, -1L));
    }

    public Request bodyStream(InputStream instream, ContentType contentType) {
        return this.body(new InputStreamEntity(instream, -1L, contentType));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }
}

