/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.sort;

import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.core.sort.ModuleDescriptorSorter;
import com.crashlytics.reloc.org.apache.ivy.core.sort.SortEngineSettings;
import com.crashlytics.reloc.org.apache.ivy.core.sort.SortOptions;
import com.crashlytics.reloc.org.apache.ivy.plugins.circular.CircularDependencyException;
import com.crashlytics.reloc.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import com.crashlytics.reloc.org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import com.crashlytics.reloc.org.apache.ivy.plugins.version.VersionMatcher;
import com.crashlytics.reloc.org.apache.ivy.util.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings settings) {
        if (settings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = settings;
    }

    public List<IvyNode> sortNodes(Collection<IvyNode> nodes, SortOptions options) {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> dependenciesMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> nulls = new ArrayList<IvyNode>();
        for (IvyNode node : nodes) {
            if (node.getDescriptor() == null) {
                nulls.add(node);
                continue;
            }
            ArrayList<IvyNode> n = (ArrayList<IvyNode>)dependenciesMap.get(node.getDescriptor());
            if (n == null) {
                n = new ArrayList<IvyNode>();
                dependenciesMap.put(node.getDescriptor(), n);
            }
            n.add(node);
        }
        List<ModuleDescriptor> list = this.sortModuleDescriptors(dependenciesMap.keySet(), options);
        double adjustFactor = 1.3;
        ArrayList<IvyNode> ret = new ArrayList<IvyNode>((int)((double)list.size() * 1.3 + (double)nulls.size()));
        for (int i = 0; i < list.size(); ++i) {
            ModuleDescriptor md = list.get(i);
            List n = (List)dependenciesMap.get(md);
            ret.addAll(n);
        }
        ret.addAll(0, nulls);
        return ret;
    }

    public List<ModuleDescriptor> sortModuleDescriptors(Collection<ModuleDescriptor> moduleDescriptors, SortOptions options) throws CircularDependencyException {
        Checks.checkNotNull(options, "options");
        ModuleDescriptorSorter sorter = new ModuleDescriptorSorter(moduleDescriptors, this.getVersionMatcher(), options.getNonMatchingVersionReporter(), options.isUseCircularDependencyStrategy() ? this.getCircularStrategy() : IgnoreCircularDependencyStrategy.getInstance());
        return sorter.sortModuleDescriptors();
    }

    protected CircularDependencyStrategy getCircularStrategy() {
        return this.settings.getCircularDependencyStrategy();
    }

    protected VersionMatcher getVersionMatcher() {
        return this.settings.getVersionMatcher();
    }
}

