/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.obr.xml;

import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleCapability;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfo;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ExportPackage;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.xml.Capability;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.xml.CapabilityProperty;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.Version;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.text.ParseException;

public class CapabilityAdapter {
    public static void adapt(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name = capability.getName();
        if ("package".equals(name)) {
            ExportPackage exportPackage = CapabilityAdapter.getExportPackage(bundleInfo, capability);
            bundleInfo.addCapability(exportPackage);
        } else if (!"bundle".equals(name)) {
            if ("service".equals(name)) {
                BundleCapability service = CapabilityAdapter.getOSGiService(bundleInfo, capability);
                bundleInfo.addCapability(service);
            } else {
                Message.warn("Unsupported capability '" + name + "' on the bundle '" + bundleInfo.getSymbolicName() + "'");
            }
        }
    }

    private static ExportPackage getExportPackage(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String pkgName = null;
        Version version = null;
        String uses = null;
        for (CapabilityProperty property : capability.getProperties()) {
            String propName = property.getName();
            if ("package".equals(propName)) {
                pkgName = property.getValue();
                continue;
            }
            if ("version".equals(propName)) {
                version = new Version(property.getValue());
                continue;
            }
            if ("uses".equals(propName)) {
                uses = property.getValue();
                continue;
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (pkgName == null) {
            throw new ParseException("No package name for the capability", 0);
        }
        ExportPackage exportPackage = new ExportPackage(pkgName, version);
        if (uses != null) {
            String[] split = uses.trim().split(",");
            for (int i = 0; i < split.length; ++i) {
                String u = split[i];
                exportPackage.addUse(u.trim());
            }
        }
        return exportPackage;
    }

    private static BundleCapability getOSGiService(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name = null;
        Version version = null;
        for (CapabilityProperty property : capability.getProperties()) {
            String propName = property.getName();
            if ("service".equals(propName)) {
                name = property.getValue();
                continue;
            }
            if ("version".equals(propName)) {
                version = new Version(property.getValue());
                continue;
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (name == null) {
            throw new ParseException("No service name for the capability", 0);
        }
        BundleCapability service = new BundleCapability("service", name, version);
        return service;
    }
}

