/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.resolver.packager;

import com.crashlytics.reloc.org.apache.ivy.core.IvyPatternHelper;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BuiltFileResource
implements Resource {
    public static final String BUILT_ARTIFACT_PATTERN = "artifacts/[type]s/[artifact].[ext]";
    private final File file;

    public BuiltFileResource(File file) {
        this.file = file;
    }

    public BuiltFileResource(File dir, Artifact artifact) {
        this(new File(dir, IvyPatternHelper.substitute(BUILT_ARTIFACT_PATTERN, artifact)));
    }

    public String getName() {
        return this.file.toURI().toString();
    }

    public Resource clone(String name) {
        return new BuiltFileResource(new File(name));
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getContentLength() {
        return this.file.length();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

