/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Lists;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.PluginDescriptor;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.GradleParser;
import com.crashlytics.tools.utils.GradleTokenizer;
import com.crashlytics.tools.utils.GradleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndroidGradleOnboarder
extends EmptyOnboarder {
    private final PluginDescriptor _plugin;
    private final Repository _kitRepository;
    private final Kit _kit;
    private final GradleParser _parser;
    private final Code _gradleCode;

    public AndroidGradleOnboarder(PluginDescriptor plugin, Repository kitRepository, Kit kit, GradleParser parser, Code gradleCode) {
        this._plugin = plugin;
        this._kitRepository = kitRepository;
        this._kit = kit;
        this._gradleCode = gradleCode;
        this._parser = parser;
    }

    private static List<CodeChange.BlockChange> getKitChanges(Kit kit, GradleParser parser, PluginDescriptor plugin, Repository kitRepository, String lineSeparator) throws IOException, LineNotFoundException {
        ArrayList<CodeChange.BlockChange> changes = Lists.newArrayList();
        changes.addAll(AndroidGradleOnboarder.getCommonChanges(kitRepository, plugin, parser, lineSeparator));
        if (!OnboardingConstants.LEGACY_CRASHLYTICS_KIT.isSameArtifact(kit)) {
            changes.addAll(AndroidGradleOnboarder.getCrashlyticsKitUpgradeChanges(parser, lineSeparator));
        }
        changes.addAll(AndroidGradleOnboarder.getKitSpecificChanges(kit, parser, lineSeparator));
        return changes;
    }

    private static List<CodeChange.BlockChange> getCommonChanges(Repository kitRepository, PluginDescriptor plugin, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        GradleParser.SearchResult repositoryResult;
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        GradleParser.SearchResult buildscriptResult = parser.findNestedClosures("buildscript");
        if (!buildscriptResult.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, 0, GradleUtils.getTabs(0), "buildscript {", lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(plugin.getRepository().getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), plugin.getDependencyStatement(), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else {
            GradleParser.SearchResult buildscriptRepositorySearchResult = parser.findNestedClosuresEnding("buildscript", "repositories");
            if (!buildscriptRepositorySearchResult.wasFound()) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(plugin.getRepository().getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
            } else {
                Optional<String> scoped = parser.getScopeContent("buildscript", "repositories");
                if (scoped.isPresent() && !scoped.get().contains(plugin.getRepository().getUrl())) {
                    AndroidGradleOnboarder.addInsertion(changes, buildscriptRepositorySearchResult.getPosition(), lineSeparator, GradleUtils.indentString(plugin.getRepository().getGradleRepositoryString(lineSeparator), 2, lineSeparator));
                }
            }
            GradleParser.SearchResult buildscriptDependencyResult = parser.findNestedClosuresEnding("buildscript", "dependencies");
            if (!buildscriptDependencyResult.wasFound()) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), plugin.getDependencyStatement(), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
            } else if (!parser.contains(plugin.getBareDependency())) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptDependencyResult.getPosition(), lineSeparator, GradleUtils.getTabs(2), plugin.getDependencyStatement());
            }
        }
        GradleParser.SearchResult applyAndroidResult = parser.findAndroidPluginResult();
        if (!applyAndroidResult.wasFound()) {
            throw new LineNotFoundException("Failed to find apply plugin: 'android' or 'com.android.application' line.");
        }
        GradleParser.TokenSearchResult applyPluginResult = parser.findTokenSet(plugin.getApplyPluginTokens());
        if (!applyPluginResult.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, plugin.getApplyPlugin());
        }
        if (!(repositoryResult = parser.findNestedClosuresEnding("repositories")).wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, lineSeparator, GradleUtils.getTabs(0), "repositories {", lineSeparator, GradleUtils.indentString(kitRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else {
            Optional<String> scoped = parser.getScopeContent("repositories");
            if (scoped.isPresent() && !scoped.get().contains(kitRepository.getUrl())) {
                AndroidGradleOnboarder.addInsertion(changes, repositoryResult.getPosition(), lineSeparator, GradleUtils.indentString(kitRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator));
            }
        }
        return changes;
    }

    private static Collection<? extends CodeChange.BlockChange> getCrashlyticsKitUpgradeChanges(GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        LinkedList<? extends CodeChange.BlockChange> changes = Lists.newLinkedList();
        PluginDescriptor legacyPlugin = OnboardingConstants.CRASHLYTICS_PLUGIN;
        changes.addAll(AndroidGradleOnboarder.remove(parser, OnboardingConstants.LEGACY_CRASHLYTICS_KIT.getGradleDependencyString(lineSeparator), "dependencies"));
        changes.addAll(AndroidGradleOnboarder.remove(parser, OnboardingConstants.LEGACY_CRASHLYTICS_REPOSITORY.getGradleRepositoryString(lineSeparator), "repositories"));
        changes.addAll(AndroidGradleOnboarder.remove(parser, legacyPlugin.getRepository().getGradleRepositoryString(lineSeparator), "buildscript", "repositories"));
        changes.addAll(AndroidGradleOnboarder.remove(parser, legacyPlugin.getDependencyStatement(), "buildscript", "dependencies"));
        changes.addAll(AndroidGradleOnboarder.removeTokens(parser.findTokenSet(legacyPlugin.getApplyPluginTokens()), 0).asSet());
        return changes;
    }

    private static Collection<? extends CodeChange.BlockChange> remove(GradleParser parser, String content, String ... scope) throws IOException {
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosures(scope);
        if (!dependencyPosition.wasFound()) {
            return Collections.emptyList();
        }
        Optional<String> scoped = parser.getScopeContent(scope);
        if (!scoped.isPresent()) {
            return Collections.emptyList();
        }
        return AndroidGradleOnboarder.removeTokens(new GradleParser(new GradleTokenizer(scoped.get())).tokenizeAndFind(content), dependencyPosition.getPosition()).asSet();
    }

    private static Optional<? extends CodeChange.BlockChange> removeTokens(GradleParser.TokenSearchResult tokens, int offset) {
        if (tokens.wasFound()) {
            int start;
            int end = start = offset + tokens.getPosition();
            for (String tokenToRemove : tokens.getTokens()) {
                start -= tokenToRemove.length();
            }
            return Optional.of(new CodeChange.Deletion(start, end));
        }
        return Optional.absent();
    }

    private static List<CodeChange.BlockChange> getKitSpecificChanges(Kit kit, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosuresEnding("dependencies");
        GradleParser.SearchResult applyAndroidResult = parser.findAndroidPluginResult();
        if (!dependencyPosition.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, GradleUtils.getTabs(0), "dependencies {", lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else if (!parser.contains(kit.getBareGradleDependencyString())) {
            AndroidGradleOnboarder.addInsertion(changes, dependencyPosition.getPosition(), lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator));
        }
        return changes;
    }

    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        try {
            String codeAsString = this._gradleCode.getCode();
            String lineSeparator = this.getLineSeparator(codeAsString);
            List<CodeChange.BlockChange> changes = AndroidGradleOnboarder.getKitChanges(this._kit, this._parser, this._plugin, this._kitRepository, lineSeparator);
            return Collections.singletonList(new CodeChange("build.gradle", this._gradleCode, changes));
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse build.gradle", e);
        }
        catch (LineNotFoundException e) {
            DeveloperTools.logW("Crashlytics was unable to find a necessary line in the file.", e);
        }
        catch (Exception e) {
            DeveloperTools.logW("Crashlytics was unable to parse file.", e);
        }
        return Collections.singletonList(new CodeChange("build.gradle", this._gradleCode, Collections.<CodeChange.BlockChange>emptyList()));
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() throws OnboardException {
        String panelName = "build.gradle";
        try {
            InputStream manifestStream = AndroidGradleOnboarder.class.getClassLoader().getResourceAsStream("examples/build.gradle.txt");
            String gradleContents = FileUtils.streamToString(manifestStream);
            manifestStream.close();
            StubCode exampleCode = new StubCode(gradleContents);
            AndroidGradleOnboarder onboarder = new AndroidGradleOnboarder(this._plugin, this._kitRepository, this._kit, new GradleParser(new GradleTokenizer(gradleContents)), exampleCode);
            return onboarder.getCodeChanges();
        }
        catch (OnboardException e) {
            DeveloperTools.logE("Could not onboard build.gradle example at examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not load example source: examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
    }

    private static void addInsertion(List<CodeChange.BlockChange> changesToCodeBlocks, int insertPosition, String ... text) {
        StringBuilder sb = new StringBuilder();
        for (String item : text) {
            sb.append(item);
        }
        CodeChange.Insertion insertion = new CodeChange.Insertion(insertPosition, sb.toString());
        DeveloperTools.logD(insertion.toString());
        changesToCodeBlocks.add(insertion);
    }

    protected String getLineSeparator(String contents) {
        return FileUtils.getLineSeparator(contents);
    }

    private static class LineNotFoundException
    extends Exception {
        public LineNotFoundException(String lineDescription) {
            super(lineDescription);
        }
    }
}

