/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Predicate;
import com.crashlytics.reloc.com.google.common.collect.Iterables;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.utils.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CodeChange {
    private final List<BlockChange> _changes;
    private final String _changeTitle;
    private final Code _targetCode;

    public static CodeChange createEmptyChange(String changeTitle) {
        return new CodeChange(changeTitle, new StubCode(""), Collections.<BlockChange>emptyList());
    }

    public CodeChange(String changeTitle, Code targetCode, Collection<BlockChange> changes) {
        if (null == changeTitle) {
            throw new IllegalArgumentException("Change title must not be null.");
        }
        if (null == targetCode) {
            throw new IllegalArgumentException("Target Code must not be null.");
        }
        if (null == changes) {
            throw new IllegalArgumentException("Changes must not be null.");
        }
        this._changeTitle = changeTitle;
        this._targetCode = targetCode;
        this._changes = new LinkedList<BlockChange>(changes);
        Collections.sort(this._changes);
    }

    public Code getTarget() {
        return this._targetCode;
    }

    public static boolean isSame(List<CodeChange> onboardChanges1, List<CodeChange> onboardChanges2) {
        if (onboardChanges1 == null && onboardChanges2 == null) {
            return true;
        }
        if (onboardChanges1 == null || onboardChanges2 == null || onboardChanges1.size() != onboardChanges2.size()) {
            return false;
        }
        Iterator<CodeChange> onboardChanges1Itr = onboardChanges1.iterator();
        Iterator<CodeChange> onboardChanges2Itr = onboardChanges2.iterator();
        boolean isSame = true;
        while (onboardChanges1Itr.hasNext() && onboardChanges2Itr.hasNext()) {
            CodeChange change2;
            CodeChange change1 = onboardChanges1Itr.next();
            if (change1.isSameAs(change2 = onboardChanges2Itr.next())) continue;
            isSame = false;
        }
        return isSame;
    }

    public boolean hasUpgrade() {
        return Iterables.any(this._changes, new Predicate<BlockChange>(){

            @Override
            public boolean apply(BlockChange input) {
                return input instanceof LegacyDeletion;
            }
        });
    }

    public boolean isSameAs(CodeChange that) {
        try {
            return this._changeTitle.equals(that._changeTitle) && ((Object)this._changes).equals(that._changes) && this._targetCode.getCode().equals(that._targetCode.getCode());
        }
        catch (IOException e) {
            return false;
        }
    }

    public void applyChange(Code code) throws Code.CodeModificationException {
        try {
            code.start();
            for (BlockChange change : this._changes) {
                change.applyChange(code);
            }
        }
        catch (Code.CodeModificationException exception) {
            throw exception;
        }
        finally {
            code.complete();
        }
    }

    public void applyChange() throws Code.CodeModificationException {
        this.applyChange(this._targetCode);
    }

    public String getTitle() {
        return this._changeTitle;
    }

    public String getPrettyTitle() {
        final AtomicInteger numChanges = new AtomicInteger(0);
        final AtomicBoolean hasDeletions = new AtomicBoolean(false);
        StubCode changeVisitor = new StubCode(""){

            @Override
            public void delete(int start, int numChars) throws Code.CodeModificationException {
                hasDeletions.set(true);
            }

            @Override
            public void insert(int start, String text) throws Code.CodeModificationException {
                if (!StringUtils.isWhitespace(text)) {
                    numChanges.incrementAndGet();
                }
            }

            @Override
            public void complete() throws Code.CodeModificationException {
            }
        };
        try {
            String changeOrAddition;
            this.applyChange(changeVisitor);
            String string = changeOrAddition = hasDeletions.get() ? "change" : "addition";
            if (numChanges.get() == 0) {
                return String.format("%s (no %ss)", this._changeTitle, changeOrAddition);
            }
            if (numChanges.get() == 1) {
                return String.format("%s (1 %s)", this._changeTitle, changeOrAddition);
            }
            return String.format("%s (%s %ss)", this._changeTitle, numChanges.get(), changeOrAddition);
        }
        catch (Code.CodeModificationException e) {
            return String.format("%s", this._changeTitle);
        }
    }

    public boolean isEmpty() {
        return this._changes.size() == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this._changes.size() == 0) {
            builder.append("Did not detect any changes required to ");
            builder.append(this._changeTitle);
        } else {
            builder.append("Updating ");
            builder.append(this._changeTitle);
            builder.append(" with the following changes:\n");
            for (BlockChange change : this._changes) {
                builder.append("---------------------------------------------\n");
                builder.append(change);
                builder.append("\n");
            }
            builder.append("---------------------------------------------");
        }
        return builder.toString();
    }

    public List<BlockChange> getChanges() {
        return this._changes;
    }

    public static class LegacyDeletion
    extends Deletion {
        public LegacyDeletion(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }
    }

    public static class Insertion
    extends BlockChange {
        private final String _content;

        public Insertion(int startOffset, String content) {
            super(startOffset, startOffset);
            this._content = content;
        }

        @Override
        public void applyChange(Code code) throws Code.CodeModificationException {
            code.insert(this._start, this._content);
        }

        @Override
        public String toString() {
            return "Insert at position " + this._start + ":" + "\n" + this._content;
        }

        public boolean equals(Object aThat) {
            if (this == aThat) {
                return true;
            }
            if (!(aThat instanceof Insertion)) {
                return false;
            }
            Insertion that = (Insertion)aThat;
            return that._start == this._start && that._end == this._end && that._content.equals(this._content);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result * (this._start + 10);
            result = 31 * result * (this._end + 10);
            result = 31 * result * (this._content == null ? 0 : this._content.hashCode());
            return result;
        }
    }

    public static class Deletion
    extends BlockChange {
        public Deletion(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @Override
        public void applyChange(Code code) throws Code.CodeModificationException {
            code.delete(this._start, this._end - this._start);
        }

        @Override
        public String toString() {
            return "Delete from position " + this._start + " to " + this._end + ":";
        }

        public boolean equals(Object aThat) {
            if (this == aThat) {
                return true;
            }
            if (!(aThat instanceof Deletion)) {
                return false;
            }
            Deletion that = (Deletion)aThat;
            return that._start == this._start && that._end == this._end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result * (this._start + 10);
            result = 31 * result * (this._end + 10);
            return result;
        }
    }

    public static abstract class BlockChange
    implements Comparable<BlockChange> {
        protected final int _start;
        protected final int _end;

        public BlockChange(int start, int end) {
            this._start = start;
            this._end = end;
        }

        public int getStart() {
            return this._start;
        }

        public int getEnd() {
            return this._end;
        }

        @Override
        public int compareTo(BlockChange o) {
            int compare = this._start - o.getStart();
            if (compare == 0) {
                if (this instanceof Deletion) {
                    compare = 1;
                } else if (o instanceof Deletion) {
                    compare = -1;
                }
            }
            return compare;
        }

        public void applyChange(Code code) throws Code.CodeModificationException {
        }

        public String toString() {
            return "Change from position " + this._start + " to " + this._end + ":";
        }
    }
}

