/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.base.Predicate;
import com.crashlytics.reloc.com.google.common.collect.Iterables;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.WorkspaceChange;
import java.util.List;

public abstract class Onboarder {
    public static boolean allEmpty(Optional<Onboarder> onboarder) {
        if (!onboarder.isPresent()) {
            return false;
        }
        try {
            return Iterables.all(onboarder.get().getCodeChanges(), new Predicate<CodeChange>(){

                @Override
                public boolean apply(CodeChange input) {
                    return input.isEmpty();
                }
            });
        }
        catch (OnboardException e) {
            DeveloperTools.logE("Crashlytics couldn't fetch code changes", e);
            return false;
        }
    }

    public abstract List<CodeChange> getCodeChanges() throws OnboardException;

    public abstract List<CodeChange> getCodeChangeDirections() throws OnboardException;

    public abstract List<WorkspaceChange> getWorkspaceChanges();
}

