/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.utils.GradleUtils;

public class Repository {
    public static final String MAVEN_USERNAME_PROPERTY = "AUTHENTICATED_MAVEN_USERNAME";
    public static final String MAVEN_PASSWORD_PROPERTY = "AUTHENTICATED_MAVEN_PASSWORD";
    public static final String MAVEN_URL_PROPERTY = "AUTHENTICATED_MAVEN_URL";
    private final String _url;
    private final String _username;
    private final String _password;
    private String _gradleRepository = null;

    public static Repository createPublicRepository(String url) {
        return new Repository(url, null, null);
    }

    public static Repository createAuthenticatedRepository(String url, String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException();
        }
        return new Repository(url, username, password);
    }

    public boolean isAuthenticated() {
        return this._username != null && this._password != null;
    }

    public boolean usesGradleProperties() {
        return OnboardingConstants.PROPERTIES_REPOSITORY.equals(this);
    }

    private Repository(String url, String username, String password) {
        this._url = url;
        this._username = username;
        this._password = password;
    }

    public String getUrl() {
        return this._url;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getGradleRepositoryString(String lineSeparator) {
        if (this._gradleRepository == null) {
            this._gradleRepository = this.buildGradleRepositoryString(lineSeparator);
        }
        return this._gradleRepository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (!this._url.equals(that._url)) {
            return false;
        }
        if (this._password != null ? !this._password.equals(that._password) : that._password != null) {
            return false;
        }
        return !(this._username != null ? !this._username.equals(that._username) : that._username != null);
    }

    public int hashCode() {
        int result = this._url.hashCode();
        result = 31 * result + (this._username != null ? this._username.hashCode() : 0);
        result = 31 * result + (this._password != null ? this._password.hashCode() : 0);
        return result;
    }

    private String buildGradleRepositoryString(String lineSeparator) {
        if (this.isAuthenticated()) {
            boolean usesGradleProperties = this.usesGradleProperties();
            String url = usesGradleProperties ? this._url : "'" + this._url + "'";
            String username = usesGradleProperties ? this._username : "'" + this._username + "'";
            String password = usesGradleProperties ? this._password : "'" + this._password + "'";
            return "maven {" + lineSeparator + GradleUtils.getTabs(1) + "url " + url + lineSeparator + GradleUtils.getTabs(1) + "credentials {" + lineSeparator + GradleUtils.getTabs(2) + "username = " + username + lineSeparator + GradleUtils.getTabs(2) + "password = " + password + lineSeparator + GradleUtils.getTabs(1) + "}" + lineSeparator + "}";
        }
        return "maven { url '" + this._url + "' }";
    }
}

