/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;

public class StringCode
implements Code {
    private StringBuilder _codeBuffer;
    private int _minimumChangeAllowedAt;
    private int _currentOffset;
    private String _inputString;

    public StringCode(String inputString) {
        this._inputString = inputString;
        this._codeBuffer = null;
        this._minimumChangeAllowedAt = 0;
        this._currentOffset = 0;
    }

    @Override
    public String getCode() {
        return this._inputString;
    }

    @Override
    public void delete(int start, int numCharsDeleting) {
        DeveloperTools.logD("deleting from " + start + " to " + (numCharsDeleting + start));
        if (start < this._minimumChangeAllowedAt) {
            throw new RuntimeException("StringCode can only be manipulated in increasing order.");
        }
        this._codeBuffer.delete(start + this._currentOffset, start + numCharsDeleting + this._currentOffset);
        this._minimumChangeAllowedAt = start;
        this._currentOffset -= numCharsDeleting;
    }

    @Override
    public void insert(int start, String text) {
        DeveloperTools.logD("inserting at " + start + " the text:" + text);
        if (start < this._minimumChangeAllowedAt) {
            throw new RuntimeException("StringCode can only be manipulated in increasing order.");
        }
        this._codeBuffer.insert(start + this._currentOffset, text);
        int numCharsAdded = text.length();
        this._minimumChangeAllowedAt = start;
        this._currentOffset += numCharsAdded;
    }

    @Override
    public void start() {
        this._codeBuffer = new StringBuilder(this._inputString);
        this._minimumChangeAllowedAt = 0;
        this._currentOffset = 0;
    }

    @Override
    public void complete() {
        this._inputString = this._codeBuffer.toString();
    }

    public String toString() {
        return this._codeBuffer.toString();
    }
}

