/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import java.io.File;
import java.io.IOException;

public class AndroidProjectStructure {
    public static String EXISTS = "Exists";
    public static String DOES_NOT_EXIST = "Doesn't Exist";
    private final File _projectRootDir;
    private final File _manifestFile;
    private final File _resDir;
    private final File _assetsDir;
    private final File _dataPath;
    private final File _propertyFile;
    private final File _ndkOutDir;
    private final File _ndkLibsOutDir;

    public AndroidProjectStructure(File projectRootDir, File manifestFile, File resDir, File assetsDir, File dataPath, File propertyFile, File ndkOutDir, File ndkLibsOutDir) {
        this._projectRootDir = projectRootDir;
        this._manifestFile = manifestFile;
        this._resDir = resDir;
        this._assetsDir = assetsDir;
        this._dataPath = dataPath;
        this._propertyFile = propertyFile;
        this._ndkOutDir = ndkOutDir;
        this._ndkLibsOutDir = ndkLibsOutDir;
    }

    public File getManifestFile() {
        return this._manifestFile;
    }

    public File getProjectRootDir() {
        return this._projectRootDir;
    }

    public File getResourceDir() {
        return this._resDir;
    }

    public File getAssetsDir() {
        return this._assetsDir;
    }

    public File getNdkOutDir() {
        return this._ndkOutDir;
    }

    public File getNdkLibsOutDir() {
        return this._ndkLibsOutDir;
    }

    public boolean allExists() {
        return this._projectRootDir.exists() && this._manifestFile.exists() && this._resDir.exists();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Root: %s (%s), ", this._projectRootDir, this.existsString(this._projectRootDir)));
        sb.append(String.format("Manifest: %s (%s), ", this._manifestFile, this.existsString(this._manifestFile)));
        sb.append(String.format("Res: %s (%s), ", this._resDir, this.existsString(this._resDir)));
        sb.append(String.format("Assets: %s (%s), ", this._assetsDir, this.existsString(this._assetsDir)));
        sb.append(String.format("Data: %s (%s), ", this._dataPath, this.existsString(this._dataPath)));
        sb.append(String.format("NDK_OUT: %s (%s), ", this._ndkOutDir, this.existsString(this._ndkOutDir)));
        sb.append(String.format("NDK_LIBS_OUT: %s (%s)", this._ndkLibsOutDir, this.existsString(this._ndkLibsOutDir)));
        return sb.toString();
    }

    public String existsString(File file) {
        return file != null && file.exists() ? EXISTS : DOES_NOT_EXIST;
    }

    public File getProjectDataPath() throws IOException {
        return this._dataPath;
    }

    public File getPropertyFile() {
        return this._propertyFile;
    }
}

