/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.BuildPropertiesManager;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;

public class AssetsBuildPropertiesManager
implements BuildPropertiesManager {
    public static final String BUILD_PROPERTIES_COMMENT = "This file is automatically generated by Crashlytics to uniquely\nidentify individual builds of your Android application.\n\nDo NOT modify, delete, or commit to source control!\n";
    private static final String BUILD_PROPERTIES_FILE_NAME = "crashlytics-build.properties";
    private final File _assetsDir;
    private final File _buildPropertiesFile;

    public AssetsBuildPropertiesManager(File assetsDir) {
        this._assetsDir = assetsDir;
        this._buildPropertiesFile = new File(this._assetsDir, BUILD_PROPERTIES_FILE_NAME);
    }

    @Override
    public boolean buildPropertiesExist() {
        return this._buildPropertiesFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties updateBuildProperties(String buildId, String appName, String packageName, String versionCode, String versionName) throws IOException {
        DeveloperTools.logD("Generating build info into assets");
        Writer writer = null;
        try {
            this._assetsDir.mkdirs();
            Properties buildProps = new Properties();
            buildProps.setProperty("app_name", appName);
            buildProps.setProperty("package_name", packageName);
            buildProps.setProperty("build_id", buildId);
            buildProps.setProperty("version_code", versionCode);
            buildProps.setProperty("version_name", versionName);
            DeveloperTools.logD("Updating build properties at: " + this._buildPropertiesFile.getAbsolutePath());
            PropertiesUtils.write(new File(this._assetsDir, BUILD_PROPERTIES_FILE_NAME), buildProps, BUILD_PROPERTIES_COMMENT);
            Properties properties = buildProps;
            return properties;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    @Override
    public void removeBuildProperties() {
        DeveloperTools.logD("Removing build properties at: " + this._buildPropertiesFile.getAbsolutePath());
        this._buildPropertiesFile.delete();
    }
}

