/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.reloc.org.json.simple.parser.JSONParser;
import com.crashlytics.reloc.org.json.simple.parser.ParseException;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.DefaultManifestData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class DeobsMetadata {
    static final String DEOBS_EXTENSION = ".zip";
    static final String DEOBS_DATA_EXTENSION = ".meta";
    static final String PARAM_BUILD_ID_V1 = "resource[uuid]";
    static final String PARAM_DEOBS_FILE_V1 = "resource[file]";
    static final String PARAM_OBFUSCATOR_ID_V1 = "resource[vendor]";
    static final String PARAM_OBFUSCATOR_VERSION_V1 = "resource[vendor_version]";
    static final String PARAM_PACKAGE_V1 = "resource[bundle_identifier]";
    static final String PARAM_VERSION_CODE_V1 = "resource[version_number]";
    static final String PARAM_VERSION_NAME_V1 = "resource[short_version_number]";
    static final String PARAM_BUILD_ID = "code_mapping[executables][][identifier]";
    static final String PARAM_DEOBS_FILE = "code_mapping[file]";
    static final String PARAM_OBFUSCATOR_ID = "code_mapping[type]";
    static final String PARAM_PACKAGE = "project[identifier]";
    static final String PARAM_VERSION_CODE = "project[build_version]";
    static final String PARAM_VERSION_NAME = "project[display_version]";
    static final String PARAM_ARCHITECTURE = "code_mapping[executables][][arch]";
    static final String PARAM_BUILD_CONFIG = "code_mapping[build_configuration]";
    static final String ARCHITECTURE_JAVA = "java";
    private String _buildId;
    private String _obfuscatorId = null;
    private String _packageId = null;
    private int _versionCode = 0;
    private String _versionName = null;
    private String _architecture = "java";

    public DeobsMetadata() {
    }

    public DeobsMetadata(String buildId, File androidManifest) throws IOException {
        this._buildId = buildId;
        DefaultManifestData manifest = DefaultManifestData.createManifest(androidManifest);
        this._packageId = manifest.getPackageName();
        Optional<Integer> manifestVersionCode = manifest.getVersionCode();
        if (!manifestVersionCode.isPresent()) {
            DeveloperTools.logD("Crashlytics did not find a version code and is interpreting it to be 0 by default");
            this._versionCode = 0;
        } else {
            this._versionCode = manifestVersionCode.get();
        }
        this._versionName = manifest.getVersionName();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this._buildId != null) {
            props.put(PARAM_BUILD_ID, this._buildId);
        }
        if (this._obfuscatorId != null) {
            props.put(PARAM_OBFUSCATOR_ID, this._obfuscatorId);
        }
        if (this._packageId != null) {
            props.put(PARAM_PACKAGE, this._packageId);
        }
        props.put(PARAM_VERSION_CODE, Integer.toString(this._versionCode));
        if (this._versionName != null) {
            props.put(PARAM_VERSION_NAME, this._versionName);
        }
        props.put(PARAM_ARCHITECTURE, this._architecture);
        return props;
    }

    public void load(File file) throws IOException {
        JSONObject props;
        JSONParser parser = new JSONParser();
        try {
            props = (JSONObject)parser.parse(new FileReader(file));
        }
        catch (ParseException e) {
            throw new IOException("Exception while parsing JSON file: " + file, e);
        }
        String buildIdParam = PARAM_BUILD_ID;
        String packageIdParam = PARAM_PACKAGE;
        String versionNameParam = PARAM_VERSION_NAME;
        String versionCodeParam = PARAM_VERSION_CODE;
        String obfuscatorParam = PARAM_OBFUSCATOR_ID;
        if (this.isAPIv1(props)) {
            buildIdParam = PARAM_BUILD_ID_V1;
            packageIdParam = PARAM_PACKAGE_V1;
            versionNameParam = PARAM_VERSION_NAME_V1;
            versionCodeParam = PARAM_VERSION_CODE_V1;
            obfuscatorParam = PARAM_OBFUSCATOR_ID_V1;
        }
        this._buildId = (String)props.get(buildIdParam);
        this._packageId = (String)props.get(packageIdParam);
        String versionCodeStr = (String)props.get(versionCodeParam);
        if (versionCodeStr == null) {
            DeveloperTools.logD("Crashlytics did not find a version code and is interpreting it to be 0 by default");
            this._versionCode = 0;
        } else {
            this._versionCode = Integer.parseInt(versionCodeStr);
        }
        this._versionName = (String)props.get(versionNameParam);
        this._obfuscatorId = (String)props.get(obfuscatorParam);
    }

    public void store(File file) throws IOException {
        JSONObject props = new JSONObject();
        for (Map.Entry<String, String> entry : this.toMap().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        FileWriter writer = new FileWriter(file);
        writer.write(props.toJSONString());
        writer.close();
    }

    public String getBuildId() {
        return this._buildId;
    }

    public void setBuildId(String buildId) {
        this._buildId = buildId;
    }

    public String getPackageId() {
        return this._packageId;
    }

    public void setPackageId(String packageId) {
        this._packageId = packageId;
    }

    public int getVersionCode() {
        return this._versionCode;
    }

    public void setVersionCode(int versionCode) {
        this._versionCode = versionCode;
    }

    public String getVersionName() {
        return this._versionName;
    }

    public void setVersionName(String versionName) {
        this._versionName = versionName;
    }

    public String getObfuscatorId() {
        return this._obfuscatorId;
    }

    public void setObfuscatorId(String obfuscatorId) {
        this._obfuscatorId = obfuscatorId;
    }

    public String getArchitecture() {
        return this._architecture;
    }

    public void setArchitecture(String architecture) {
        this._architecture = architecture;
    }

    private boolean isAPIv1(JSONObject props) {
        return props.containsKey(PARAM_BUILD_ID_V1);
    }
}

