/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.project.codemapping.csym.CSym;
import com.crashlytics.tools.android.project.codemapping.csym.CSymGenerator;
import com.crashlytics.tools.android.project.codemapping.csym.CSymIdStrategy;
import com.crashlytics.tools.utils.dwarf.DebugLineEntry;
import com.crashlytics.tools.utils.elf.EMachine;
import com.crashlytics.tools.utils.elf.ElfData;
import com.crashlytics.tools.utils.elf.ElfSymbol;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class ElfCSymGenerator
implements CSymGenerator {
    private static final String CSYM_TYPE = "elf_symtab";
    private final CSymIdStrategy _idStrategy;

    public ElfCSymGenerator(CSymIdStrategy idStrategy) {
        this._idStrategy = idStrategy;
    }

    @Override
    public CSym generateCSymFromFile(File binFile) throws IOException {
        if (!binFile.isFile()) {
            throw new IllegalArgumentException("Invalid object file: " + binFile);
        }
        String uuid = this._idStrategy.createCSymIdForFile(binFile);
        ElfData elfData = ElfData.parse(binFile);
        String arch = EMachine.getMachineName(elfData.getElfFileHeader().eMachine);
        if (arch.equalsIgnoreCase("arm") && elfData.getArmVersion().isPresent()) {
            arch = arch + String.format("v%s", elfData.getArmVersion().get());
        }
        List<ElfSymbol> elfSymbols = elfData.getElfSymbols();
        Optional<List<DebugLineEntry>> debugLineEntries = elfData.getDebugLineEntries();
        CSym.Builder builder = new CSym.Builder(uuid, CSYM_TYPE, arch);
        if (debugLineEntries.isPresent()) {
            ElfCSymGenerator.configureCSymBuilderWithDwarf(builder, elfSymbols, debugLineEntries.get());
        } else {
            ElfCSymGenerator.configureCSymBuilderWithElf(builder, elfSymbols);
        }
        return builder.build();
    }

    private static void configureCSymBuilderWithElf(CSym.Builder builder, List<ElfSymbol> elfSymbols) {
        for (ElfSymbol symbol : elfSymbols) {
            if (!ElfCSymGenerator.isNecessarySymbol(symbol)) continue;
            builder.addRange(symbol.stValue, symbol.stSize, symbol.stNameString);
        }
    }

    private static void configureCSymBuilderWithDwarf(CSym.Builder builder, List<ElfSymbol> elfSymbols, List<DebugLineEntry> lineDataList) {
        TreeMap<Long, ElfSymbol> sortedSymbolIndex = new TreeMap<Long, ElfSymbol>();
        for (ElfSymbol symbol : elfSymbols) {
            sortedSymbolIndex.put(symbol.stValue, symbol);
        }
        HashSet<Long> addressSet = new HashSet<Long>(sortedSymbolIndex.size(), 1.0f);
        for (DebugLineEntry debugLineEntry : lineDataList) {
            ElfSymbol foundSymbol;
            long address = debugLineEntry.address;
            ElfSymbol elfSymbol = foundSymbol = sortedSymbolIndex.containsKey(address) ? ElfCSymGenerator.getSymbolForAddress(sortedSymbolIndex, address) : ElfCSymGenerator.findEnclosingSymbol(sortedSymbolIndex, address);
            if (addressSet.contains(address) || !ElfCSymGenerator.isNecessarySymbol(foundSymbol)) continue;
            builder.addRange(address, foundSymbol.stSize, foundSymbol.stNameString, debugLineEntry.file, debugLineEntry.lineNumber);
            addressSet.add(address);
        }
    }

    private static ElfSymbol getSymbolForAddress(TreeMap<Long, ElfSymbol> index, long address) {
        ElfSymbol foundSymbol = index.get(address);
        if (ElfCSymGenerator.isArmMappingSymbol(foundSymbol)) {
            Long nextKey = index.higherKey(address);
            foundSymbol = nextKey != null ? index.get(nextKey) : null;
        }
        return foundSymbol;
    }

    private static ElfSymbol findEnclosingSymbol(TreeMap<Long, ElfSymbol> index, long address) {
        Long prevKey = index.lowerKey(address);
        return prevKey != null ? index.get(prevKey) : null;
    }

    private static boolean isNecessarySymbol(ElfSymbol symbol) {
        return symbol != null && (symbol.stInfo & 0xF) == 2 && symbol.stSize != 0L;
    }

    private static boolean isArmMappingSymbol(ElfSymbol symbol) {
        return symbol != null && symbol.stNameString != null && (symbol.stNameString.startsWith("$a") || symbol.stNameString.startsWith("$d") || symbol.stNameString.startsWith("$t"));
    }
}

