/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ListenableOutputStream
extends FilterOutputStream {
    private final ProgressListener _listener;
    private long _transferred = 0L;

    public ListenableOutputStream(OutputStream out, ProgressListener listener) {
        super(out);
        this._listener = listener;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this._transferred += (long)len;
        this._listener.bytesWritten(this._transferred);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this._transferred;
        this._listener.bytesWritten(this._transferred);
    }

    public static interface ProgressListener {
        public void bytesWritten(long var1);
    }
}

