/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.IssuerSpec;
import io.fabric8.certmanager.api.model.v1.IssuerSpecFluent;
import io.fabric8.certmanager.api.model.v1.IssuerSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class IssuerSpecBuilder
extends IssuerSpecFluentImpl<IssuerSpecBuilder>
implements VisitableBuilder<IssuerSpec, IssuerSpecBuilder> {
    IssuerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IssuerSpecBuilder() {
        this(false);
    }

    public IssuerSpecBuilder(Boolean validationEnabled) {
        this(new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, IssuerSpec instance) {
        this(fluent, instance, false);
    }

    public IssuerSpecBuilder(IssuerSpecFluent<?> fluent, IssuerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAcme(instance.getAcme());
        fluent.withCa(instance.getCa());
        fluent.withSelfSigned(instance.getSelfSigned());
        fluent.withVault(instance.getVault());
        fluent.withVenafi(instance.getVenafi());
        this.validationEnabled = validationEnabled;
    }

    public IssuerSpecBuilder(IssuerSpec instance) {
        this(instance, (Boolean)false);
    }

    public IssuerSpecBuilder(IssuerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAcme(instance.getAcme());
        this.withCa(instance.getCa());
        this.withSelfSigned(instance.getSelfSigned());
        this.withVault(instance.getVault());
        this.withVenafi(instance.getVenafi());
        this.validationEnabled = validationEnabled;
    }

    public IssuerSpec build() {
        IssuerSpec buildable = new IssuerSpec(this.fluent.getAcme(), this.fluent.getCa(), this.fluent.getSelfSigned(), this.fluent.getVault(), this.fluent.getVenafi());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssuerSpecBuilder that = (IssuerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

