/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuth;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuthFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class VaultKubernetesAuthFluentImpl<A extends VaultKubernetesAuthFluent<A>>
extends BaseFluent<A>
implements VaultKubernetesAuthFluent<A> {
    private String mountPath;
    private String role;
    private SecretKeySelectorBuilder secretRef;

    public VaultKubernetesAuthFluentImpl() {
    }

    public VaultKubernetesAuthFluentImpl(VaultKubernetesAuth instance) {
        this.withMountPath(instance.getMountPath());
        this.withRole(instance.getRole());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    @Deprecated
    public A withNewMountPath(String arg0) {
        return this.withMountPath(new String(arg0));
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public A withRole(String role) {
        this.role = role;
        return (A)this;
    }

    @Override
    public Boolean hasRole() {
        return this.role != null;
    }

    @Override
    @Deprecated
    public A withNewRole(String arg0) {
        return this.withRole(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretKeySelector getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretKeySelector buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretKeySelector secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretKeySelectorBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String key, String name) {
        return this.withSecretRef(new SecretKeySelector(key, name));
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRefLike(SecretKeySelector item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretKeySelectorBuilder().build());
    }

    @Override
    public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretKeySelector item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultKubernetesAuthFluentImpl that = (VaultKubernetesAuthFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(that.role) : that.role != null) {
            return false;
        }
        return !(this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.role, this.secretRef, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<VaultKubernetesAuthFluent.SecretRefNested<N>>
    implements VaultKubernetesAuthFluent.SecretRefNested<N>,
    Nested<N> {
        SecretKeySelectorBuilder builder;

        SecretRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultKubernetesAuthFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

