/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.chunked;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import io.fabric8.maven.docker.access.DockerAccessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class EntityStreamReaderUtil {
    private EntityStreamReaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processJsonStream(JsonEntityResponseHandler handler, InputStream stream) throws IOException {
        handler.start();
        try (JsonReader json = new JsonReader((Reader)new InputStreamReader(stream));){
            JsonParser parser = new JsonParser();
            json.setLenient(true);
            while (json.peek() != JsonToken.END_DOCUMENT) {
                JsonElement element = parser.parse(json);
                handler.process(element.getAsJsonObject());
            }
        }
        finally {
            handler.stop();
        }
    }

    public static interface JsonEntityResponseHandler {
        public void process(JsonObject var1) throws DockerAccessException;

        public void start();

        public void stop();
    }
}

