/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import io.fabric8.maven.docker.access.chunked.EntityStreamReaderUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.stream.Stream;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class HcChunkedResponseHandlerWrapper
implements ResponseHandler<Object> {
    private final EntityStreamReaderUtil.JsonEntityResponseHandler handler;

    HcChunkedResponseHandlerWrapper(EntityStreamReaderUtil.JsonEntityResponseHandler handler) {
        this.handler = handler;
    }

    public Object handleResponse(HttpResponse response) throws IOException {
        try (InputStream stream = response.getEntity().getContent();){
            ByteArrayOutputStream baos;
            ByteArrayInputStream is;
            if (HcChunkedResponseHandlerWrapper.isJsonCheckedByHeader(response)) {
                EntityStreamReaderUtil.processJsonStream(this.handler, stream);
            } else if (HcChunkedResponseHandlerWrapper.isMissingContentType(response) && HcChunkedResponseHandlerWrapper.isJsonCheckedByBody(is = new ByteArrayInputStream((baos = this.getMultipleReadbleOutputStream(stream)).toByteArray()))) {
                is = new ByteArrayInputStream(baos.toByteArray());
                EntityStreamReaderUtil.processJsonStream(this.handler, is);
            }
        }
        return null;
    }

    private ByteArrayOutputStream getMultipleReadbleOutputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos;
    }

    private static boolean isJsonCheckedByBody(InputStream is) {
        try {
            JsonReader json = new JsonReader((Reader)new InputStreamReader(is));
            JsonParser parser = new JsonParser();
            parser.parse(json);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            return false;
        }
        return true;
    }

    private static boolean isMissingContentType(HttpResponse response) {
        return Stream.of(response.getAllHeaders()).noneMatch(h -> h.getName().equalsIgnoreCase("Content-Type"));
    }

    private static boolean isJsonCheckedByHeader(HttpResponse response) {
        return Stream.of(response.getAllHeaders()).filter(h -> h.getName().equalsIgnoreCase("Content-Type")).anyMatch(h -> h.getValue().toLowerCase().startsWith("application/json"));
    }
}

