/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.AuthConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthConfigList {
    private final List<AuthConfig> authConfigs = new ArrayList<AuthConfig>();

    public AuthConfigList() {
    }

    public AuthConfigList(AuthConfig authConfig) {
        this();
        if (authConfig != null) {
            this.authConfigs.add(authConfig);
        }
    }

    public void addAuthConfig(AuthConfig authConfig) {
        Objects.requireNonNull(authConfig);
        this.authConfigs.add(authConfig);
    }

    public String toJson() {
        JsonObject auths = new JsonObject();
        for (AuthConfig authConfig : this.authConfigs) {
            JsonObject auth = authConfig.toJsonObject().getAsJsonObject("auths");
            for (Map.Entry entry : auth.entrySet()) {
                auths.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        JsonObject root = new JsonObject();
        if (auths.size() > 0) {
            root.add("auths", (JsonElement)auths);
        }
        return root.toString();
    }

    public boolean isEmpty() {
        return this.authConfigs.isEmpty();
    }

    public int size() {
        return this.authConfigs.size();
    }
}

