/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ArchiveCompression;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="save")
public class SaveMojo
extends AbstractDockerMojo {
    private static final ArchiveCompression STANDARD_ARCHIVE_COMPRESSION = ArchiveCompression.gzip;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(property="docker.save.name")
    String saveName;
    @Parameter(property="docker.save.names")
    List<String> saveNames;
    @Parameter(property="docker.save.alias")
    String saveAlias;
    @Parameter(property="docker.save.aliases")
    List<String> saveAliases;
    @Parameter
    String saveFile;
    @Parameter(property="docker.skip.save", defaultValue="false")
    boolean skipSave;
    @Parameter(property="docker.save.classifier")
    String saveClassifier;

    @Override
    protected void executeInternal(ServiceHub serviceHub) throws DockerAccessException, MojoExecutionException {
        List<ImageConfiguration> images = this.getResolvedImages();
        if (this.skipSaveFor(images)) {
            return;
        }
        List<ImageConfiguration> imagesToSave = this.getImagesToSave(images);
        List<String> imageNames = imagesToSave.stream().map(ic -> ic.getName()).collect(Collectors.toList());
        String fileName = this.getFileName(imageNames);
        this.ensureSaveDir(fileName);
        for (String imageName : imageNames) {
            this.log.info("Saving image %s to %s", imageName, fileName);
            if (serviceHub.getQueryService().hasImage(imageName)) continue;
            throw new MojoExecutionException("No image " + imageName + " exists");
        }
        long time = System.currentTimeMillis();
        ArchiveCompression compression = ArchiveCompression.fromFileName(fileName);
        if (imageNames.size() == 1) {
            String imageName = imageNames.get(0);
            serviceHub.getDockerAccess().saveImage(imageName, fileName, compression);
            this.log.info("%s: Saved image to %s in %s", imageName, fileName, EnvUtil.formatDurationTill(time));
        } else {
            serviceHub.getDockerAccess().saveImages(imageNames, fileName, compression);
            this.log.info("%s: Saved image to %s in %s", imageNames, fileName, EnvUtil.formatDurationTill(time));
        }
        String classifier = this.getClassifier(imagesToSave.get(0));
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.project, compression.getFileSuffix(), classifier, new File(fileName));
        }
    }

    private boolean skipSaveFor(List<ImageConfiguration> images) {
        if (this.skipSave) {
            this.log.info("docker:save skipped because `skipSave` config is set to true", new Object[0]);
            return true;
        }
        if (this.saveName == null && this.saveAlias == null && images.stream().allMatch(i -> i.getBuildConfiguration() == null)) {
            this.log.info("docker:save skipped because no image has a build configuration defined", new Object[0]);
            return true;
        }
        return false;
    }

    private String getFileName(List<String> iNames) throws MojoExecutionException {
        String configuredFileName = this.getConfiguredFileName();
        if (configuredFileName != null) {
            if (new File(configuredFileName).isAbsolute()) {
                return configuredFileName;
            }
            return new File(this.project.getBasedir(), configuredFileName).getAbsolutePath();
        }
        if (this.saveAlias != null) {
            return this.completeCalculatedFileName(this.saveAlias + "-" + this.project.getVersion() + "." + STANDARD_ARCHIVE_COMPRESSION.getFileSuffix());
        }
        if (iNames.size() == 1) {
            ImageName imageName = new ImageName(iNames.get(0));
            return this.completeCalculatedFileName(imageName.getSimpleName() + "-" + imageName.getTag()) + "." + STANDARD_ARCHIVE_COMPRESSION.getFileSuffix();
        }
        throw new MojoExecutionException("More than one image to save. Please configure a fileName.");
    }

    private String getConfiguredFileName() {
        Properties[] propsList = new Properties[]{System.getProperties(), this.project.getProperties()};
        for (String key : new String[]{"docker.save.file", "docker.file", "file"}) {
            for (Properties props : propsList) {
                if (!props.containsKey(key)) continue;
                return props.getProperty(key);
            }
        }
        return this.saveFile;
    }

    private String completeCalculatedFileName(String file) {
        return new File(this.project.getBuild().getDirectory(), file.replace("/", "-")).getAbsolutePath();
    }

    private void ensureSaveDir(String fileName) throws MojoExecutionException {
        File saveDir = new File(fileName).getAbsoluteFile().getParentFile();
        if (!saveDir.exists() && !saveDir.mkdirs()) {
            throw new MojoExecutionException("Can not create directory " + saveDir + " for storing save file");
        }
    }

    private List<ImageConfiguration> getImagesToSave(List<ImageConfiguration> images) throws MojoExecutionException {
        if (this.saveName == null && this.saveAlias == null && (this.saveNames == null || this.saveNames != null && this.saveNames.isEmpty()) && (this.saveAliases == null || this.saveAliases != null && this.saveAliases.isEmpty())) {
            List<ImageConfiguration> buildImages = this.getImagesWithBuildConfig(images);
            if (buildImages.size() == 1) {
                return Arrays.asList(buildImages.get(0));
            }
            throw new MojoExecutionException("More than one image with build configuration is defined. Please specify the image with 'docker.save.name', 'docker.save.alias', 'docker.save.names' or 'docker.save.aliases'.");
        }
        this.checkValidImageInputsOrThrow();
        List<String> saveNamesPendingToSave = this.getSaveNamesPendingToSave();
        List<String> saveAliasesPendingToSave = this.getSaveAliasesPendingToSave();
        ArrayList<ImageConfiguration> imagesToSave = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration ic : images) {
            if (this.equalName(ic) || this.containsName(ic)) {
                imagesToSave.add(ic);
                saveNamesPendingToSave.remove(ic.getName());
                continue;
            }
            if (!this.equalAlias(ic) && !this.containsAlias(ic)) continue;
            imagesToSave.add(ic);
            saveAliasesPendingToSave.remove(ic.getAlias());
        }
        if (!saveNamesPendingToSave.isEmpty()) {
            throw new MojoExecutionException(saveNamesPendingToSave.size() > 1 ? "Can not find images with name: " + saveNamesPendingToSave : "Can not find image with name: " + saveNamesPendingToSave.get(0));
        }
        if (!saveAliasesPendingToSave.isEmpty()) {
            throw new MojoExecutionException(saveAliasesPendingToSave.size() > 1 ? "Can not find images with alias: " + saveAliasesPendingToSave : "Can not find image with alias: " + saveAliasesPendingToSave.get(0));
        }
        return imagesToSave;
    }

    private void checkValidImageInputsOrThrow() throws MojoExecutionException {
        if (this.saveName != null && this.saveAlias != null) {
            throw new MojoExecutionException("Cannot specify both name and alias.");
        }
        if (this.saveName != null && this.saveNames != null && !this.saveNames.isEmpty()) {
            throw new MojoExecutionException("Cannot specify both name and name list.");
        }
        if (this.saveName != null && this.saveAliases != null && !this.saveAliases.isEmpty()) {
            throw new MojoExecutionException("Cannot specify both name and alias list.");
        }
        if (this.saveAlias != null && this.saveNames != null && !this.saveNames.isEmpty()) {
            throw new MojoExecutionException("Cannot specify both alias and name list.");
        }
        if (this.saveAlias != null && this.saveAliases != null && !this.saveAliases.isEmpty()) {
            throw new MojoExecutionException("Cannot specify both alias and alias list.");
        }
        if (this.saveNames != null && !this.saveNames.isEmpty() && this.saveAliases != null && !this.saveAliases.isEmpty()) {
            throw new MojoExecutionException("Cannot specify both name list and alias list.");
        }
    }

    private List<String> getSaveNamesPendingToSave() {
        ArrayList<String> exit = new ArrayList<String>();
        if (this.saveName != null) {
            exit.add(this.saveName);
        }
        if (this.saveNames != null && !this.saveNames.isEmpty()) {
            exit.addAll(this.saveNames);
        }
        return exit;
    }

    private List<String> getSaveAliasesPendingToSave() {
        ArrayList<String> exit = new ArrayList<String>();
        if (this.saveAlias != null) {
            exit.add(this.saveAlias);
        }
        if (this.saveAliases != null && !this.saveAliases.isEmpty()) {
            return exit;
        }
        return exit;
    }

    private List<ImageConfiguration> getImagesWithBuildConfig(List<ImageConfiguration> images) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration image : images) {
            if (image.getBuildConfiguration() == null) continue;
            ret.add(image);
        }
        return ret;
    }

    private String getClassifier(ImageConfiguration image) {
        if (this.saveClassifier == null || this.saveClassifier.length() == 0) {
            return null;
        }
        return this.saveClassifier.replace("%a", image.getAlias() == null ? "" : image.getAlias());
    }

    private boolean equalAlias(ImageConfiguration ic) {
        return this.saveAlias != null && this.saveAlias.equals(ic.getAlias());
    }

    private boolean equalName(ImageConfiguration ic) {
        return this.saveName != null && this.saveName.equals(ic.getName());
    }

    private boolean containsAlias(ImageConfiguration ic) {
        return this.saveAliases != null && !this.saveAliases.isEmpty() && this.saveAliases.contains(ic.getAlias());
    }

    private boolean containsName(ImageConfiguration ic) {
        return this.saveNames != null && !this.saveNames.isEmpty() && this.saveNames.contains(ic.getName());
    }
}

