/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.ServiceProtocol;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class ServiceConfiguration {
    @Parameter
    private String name;
    @Parameter
    List<Port> ports;
    @Parameter
    private boolean headless = false;
    @Parameter
    private String type;

    public String getName() {
        return this.name;
    }

    public List<Port> getPorts() {
        return this.ports != null ? this.ports : Collections.emptyList();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public String getType() {
        return this.type;
    }

    public static class Port {
        @Parameter
        ServiceProtocol protocol;
        @Parameter
        int port;
        @Parameter
        int targetPort;
        @Parameter
        Integer nodePort;
        @Parameter
        String name;

        public ServiceProtocol getProtocol() {
            return this.protocol;
        }

        public int getPort() {
            return this.port;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public Integer getNodePort() {
            return this.nodePort;
        }

        public String getName() {
            return this.name;
        }

        public static class Builder {
            Port config = new Port();

            public Builder name(String name) {
                this.config.name = name;
                return this;
            }

            public Builder protocol(ServiceProtocol protocol) {
                this.config.protocol = protocol;
                return this;
            }

            public Builder port(int port) {
                this.config.port = port;
                return this;
            }

            public Builder targetPort(int targetPort) {
                this.config.targetPort = targetPort;
                return this;
            }

            public Builder nodePort(Integer nodePort) {
                this.config.nodePort = nodePort;
                return this;
            }

            public Port build() {
                return this.config;
            }
        }
    }

    public static class Builder {
        private ServiceConfiguration config = new ServiceConfiguration();

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder ports(List<Port> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder headless(boolean headless) {
            this.config.headless = headless;
            return this;
        }

        public Builder type(String type) {
            this.config.type = type;
            return this;
        }

        public ServiceConfiguration build() {
            return this.config;
        }
    }
}

