/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.PluginServiceFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

public class ClassUtil {
    private static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !pathname.getName().startsWith(".");
        }
    };
    private static final FileFilter CLASS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".class");
        }
    };

    public static Set<String> getResources(String resource) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        for (ClassLoader cl : ClassUtil.getClassLoaders()) {
            Enumeration<URL> urlEnum = cl.getResources(resource);
            ret.addAll(ClassUtil.extractUrlAsStringsFromEnumeration(urlEnum));
        }
        return ret;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), PluginServiceFactory.class.getClassLoader()};
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }

    public static <T> Class<T> classForName(String className) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        ClassLoader[] classLoaderArray = ClassUtil.getClassLoaders();
        int n = classLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader loader = classLoaderArray[i]; loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(className, true, loader);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }

    public static List<String> findMainClasses(File rootDir) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if (!rootDir.exists()) {
            return ret;
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Path %s is not a directory", rootDir.getPath()));
        }
        ClassUtil.findClasses(ret, rootDir, rootDir.getAbsolutePath() + "/");
        return ret;
    }

    private static void findClasses(List<String> classes, File dir, String prefix) throws IOException {
        for (File subDir : dir.listFiles(DIR_FILTER)) {
            ClassUtil.findClasses(classes, subDir, prefix);
        }
        for (File classFile : dir.listFiles(CLASS_FILE_FILTER)) {
            try (FileInputStream is = new FileInputStream(classFile);){
                if (!ClassUtil.hasMainMethod(is)) continue;
                classes.add(ClassUtil.convertToClass(classFile.getAbsolutePath(), prefix));
            }
        }
    }

    private static boolean hasMainMethod(InputStream is) throws IOException {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass(is);
            CtClass stringClass = pool.get("java.lang.String[]");
            CtMethod mainMethod = ctClass.getDeclaredMethod("main", new CtClass[]{stringClass});
            return mainMethod.getReturnType() == CtClass.voidType && Modifier.isStatic((int)mainMethod.getModifiers()) && Modifier.isPublic((int)mainMethod.getModifiers());
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static String convertToClass(String name, String prefix) {
        String ret = name.replaceAll("[/\\\\]", ".");
        ret = ret.substring(0, name.length() - ".class".length());
        return ret.substring(prefix.length());
    }
}

